package sneps3.corecode;

/**
 * Interface for sets of relations.
 * Set interfaces are created in SNePS 3 to provide provide the power of
 * control over how costly set operations are done, while hiding such
 * implementation details from higher levels.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface RelationSet extends sneps3.classes.RelationSet{

  /**
   * Add a relation to this set.
   *
   * @param relation the relation to be added
   * @return <code>true</code> if the relation was added,
   *  <code>false</code> otherwise.
   */
  boolean add(final Relation r);


  /**
   * Remove a relation from this set.
   *
   * @param relation the relation to be removed
   * @return <code>true</code> if the relation was removed,
   *  <code>false</code> otherwise.
   */
  Relation remove(final String name);

  
  /**
   * Remove all relations from this set.
   */
  void clear();


}
