package sneps3.corecode;
import java.io.*;


/**
 * Default implementation of the interface in Cable.java
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
class S3_Cable implements Cable, Serializable, Cloneable {
  

  /**
   * Node this cable is comming out of.
   *
   * @serial
   */
  protected Node _root;


  /**
   * Relation associated with this cable.
   *
   * @serial
   */
  protected Relation _relation;


  /**
   * The nodes pointed to by this cable.
   *
   * @serial
   */
  protected NodeSet _nodeset;


  /**
   * Lock on the mutators.
   *
   * @serial
   */
  protected boolean _lock;
  

  /**
   * Class constructor.
   */
  public S3_Cable(){
    _root=null;
    _relation = null;
    _nodeset = null;
    _lock = false;
   }
  
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in SemanticClass.java, see that +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


  public sneps3.classes.Relation getRelation(){
    return _relation;
  }
  

  public sneps3.classes.NodeSet getNodeSet(){
    return _nodeset;
  }


  public sneps3.classes.Node getRoot(){
    return _root;
  }

  public boolean setRelation(final Relation _r){
    if (_lock)
      return false;

    if( _r == null)
      return false;
    
    if( _nodeset != null && !_nodeset.isEmpty())
      return false;
    
    _relation = _r;
	return true;
  }
  

  public boolean setNodeSet(final NodeSet ns){
    if (_lock)
      return (false);
    _nodeset = ns;
    return (true);
  }


  public boolean setRoot(final Node n){
    if (_lock)
      return (false);
    _root=n;
    return (true);
  }


  public boolean equals(final sneps3.classes.Cable rhs){
    return (getRelation().equals(rhs.getRelation()) &&
        getRoot().equals(rhs.getRoot()) &&
        getNodeSet().equals(rhs.getNodeSet()));
  }

 
  public Cable twine(Cable c){
    if (getRelation().equals(c.getRelation())){
      return null;
      // throw exception
    }
    Cable ret=null;
    ret=(Cable)clone();

    NodeSet ns= (NodeSet)ret.getNodeSet();
    if(c != null){
      java.util.Iterator nsi;
      nsi = c.getNodeSet().iterator();
      while( nsi.hasNext() )
        ns.add((Node)nsi.next());
    }
    _lock=false;
    ret.setNodeSet(ns);
    return ret;
  }
  

  public boolean isAdjustableTo(final sneps3.classes.Cable c){
    // compare the nodeset according to the relation's adjustability
    sneps3.classes.NodeSet ns = c.getNodeSet();
    
    switch( _relation.getAdjust() ){
    case Relation.NONE:
      return _nodeset.equals( ns );
	case Relation.REDUCE: 
          return _nodeset.contains( ns );
    case Relation.EXPAND:
      return ns.contains( _nodeset );
    default:
      // Note: here we should really throw an exception ...
      return false;
    }
  }
  

  public String toString(final int level)
  {
    String ind="";
      for(int i=0; i<level; i++)
        ind+=Defaults.INDENT;
      String retVal = ind+"Relation: " + _relation.getName() + "   Nodes: \n";
      retVal += _nodeset.toString(level+1);
      return retVal;
  }
  

  public String toString(){
    return (toString(0));
  }
  

  public Object clone(){
    Object ret=null;
    try{ret=super.clone();}
    catch(CloneNotSupportedException e){
      //This should never happen because the Cloneable interface IS implemented
    }
    return (ret);
  }


  public boolean lock(){
    boolean ret=_lock;
    _lock=true;
    return (ret);
  }
  
}
