package sneps3.corecode;
import java.io.*;
import java.util.*;


/**
 * A CableSet is a collection of Cables.  Semanticly these Cables are
 * unordered.  Additionally, no two Cables in a CableSet have the same
 * Relation.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
class S3_CableSet implements CableSet, Serializable, Cloneable{


  /**
   * Hashtable to hold the actual cables in this set.
   *
   * @serial
   */
  protected Hashtable _table;


  /**
   * Class constructor.
   */
  public S3_CableSet(){
    _table=new Hashtable();
  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in Relation.java, see that      +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


  public boolean add(final Cable c){
    if (findCable(c.getRelation())!=null)
      return(false);
    _table.put(c.getRelation().getName(),c);
    return(true);
  }

  public boolean remove(final Cable c){
    if (_table.remove(c)==null)
      return(false);
    return (true);
  }

  public Cable forceCable(final Cable c){
    
    Cable oldCable=(Cable)findCable(c.getRelation()).clone();
    if (oldCable==null){
      add(c);
      return (c);
    }
    Cable newCable = oldCable.twine(c);
    remove(oldCable);
     add(newCable);
     return (newCable);
  }   
  
  public sneps3.classes.Cable findCable(final sneps3.classes.Relation rel){
    Iterator c=iterator();
    while (c.hasNext()){
      Cable ret = (Cable)(c.next()); 
      if (ret.getRelation().equals(rel))
        return (ret);
    }
    return(null);
  }

  public String toString()
  {
    String retVal = "";
    java.util.Iterator c;
    c = iterator();
    while(c.hasNext())
      retVal += ((Cable)c.next()).toString();
    retVal += '\n';
    return retVal;
  }

  public Iterator iterator()
  {
    return (_table.values().iterator());
  }

  public String toString(int level){
    return null;
  }

  public Object clone(){
    Object ret=null;
    try{ret=super.clone();}
    catch(CloneNotSupportedException e){
      //This should never happen because the Cloneable interface IS implemented
    }
    return (ret);
  }

}



