package sneps3.corecode;
import java.io.*;
import java.util.*;

/**
 * The default implementation of case frames, outlined in the CaseFrame
 * interface.
 */
class  S3_CaseFrame implements CaseFrame, Cloneable, Serializable, Comparable
{
        
  /**     
   * Member variable for semantic class for this case frame
   *
   * @serial
   */
  protected SemanticClass _semanticClass;


  /**     
   * Member variable: the set of relations for this case frame
   *
   * @serial
   */
  protected RelationSet _relations;


  /**
   * Set of nodes that have this case frame.
   *
   * @serial
   */
  protected NodeSet _nodes;


  /**
   * Stores a unique id for the case frame.
   *
   * @serial
   */
  protected String _hashValue;

  /**
   * Access lock for the mutators.  Mutators may only operate when this field
   * is set to <code>false</code>.
   *
   * @serial
   */
  protected boolean _lock;
  

  /**
   * Class constructor.
   *
   * @return an empty case frame
   */
  public S3_CaseFrame()
  {
    _semanticClass = null;
    _relations = null;	
    _nodes=null;
    _lock=false;
  }
  

  /**
   * checks to make sure that every relation that is in other but not in this
   * is expandable with limit of zero
   */
  protected boolean OtherReduces(final sneps3.classes.CaseFrame rhs)
  {
    
    Iterator iterateOtherRelations = 
      rhs.getRelations().iterator();
    
    //loop for each relation in the set.
    while(iterateOtherRelations.hasNext())
      {//should we check instanceof?
        Relation nextRel = (Relation)iterateOtherRelations.next();
        //if both relations have it keep going
        if (getRelations().contains(nextRel.getName()))
          continue;
        else //otherwise relation needs to be expand lim=0
          if(nextRel.getAdjust()!=Relation.EXPAND ||
              nextRel.getLimit()!=0)
            return false;
      }
    return true;
  }
  

  /**
   * Check to make sure that every relation that is in this but not in 
   * other is reducable with limit of zero
   */
  protected boolean ThisExpands(final sneps3.classes.CaseFrame rhs)
  {
    Iterator iterateOurRelations = 
      getRelations().iterator(); 
    //loop for each relation in the set.
    while(iterateOurRelations.hasNext())
      {
				//should we check instanceof?
        Relation nextRel = (Relation)iterateOurRelations.next();
				//if both relations have it keep going
        if (rhs.getRelations().contains(nextRel.getName()))
          continue;
        else //otherwise relation needs to be reduce lim=0
          if(nextRel.getAdjust()!=Relation.REDUCE ||
              nextRel.getLimit()!=0)
            return false;
      }
    return true;
  }

  public boolean setHash(){
    if (_relations == null)
      return (false);
    Relation [] ra = (Relation [])_relations.toArray();
    java.util.Arrays.sort(ra);
    _hashValue = new String();
    for(int i=0; i<java.lang.reflect.Array.getLength(ra); i++){
      _hashValue += hashHelp(ra[i].getName()) + Defaults.SEPERATION_CHARACTER;
    }
    if (!Defaults.CASE_SENSITIVE)
      _hashValue = _hashValue.toUpperCase();
    return (true);
  }

  protected String hashHelp(String arg){
    int ind = arg.indexOf(Defaults.SEPERATION_CHARACTER);
    if (ind<0)
      return (arg);
    else
      return (arg.substring(0,ind) +
          Defaults.SEPERATION_CHARACTER + hashHelp(arg.substring(ind)));
  }

  public String getHash(){
    return (_hashValue);
  }

  public int compareTo(Object o){
    if (_relations.size()>((CaseFrame)o).getRelations().size())
      return 1;
    else if (_relations.size()<((CaseFrame)o).getRelations().size())
      return -1;
    else if (!Defaults.CASE_SENSITIVE)
      return _hashValue.compareToIgnoreCase(((CaseFrame)o).getHash());
    else
      return _hashValue.compareTo(((CaseFrame)o).getHash());
  }

  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in CaseFrame.java, see that     +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public boolean isAdjustableTo(final sneps3.classes.CaseFrame rhs)
  {
    if(! (rhs.getSemanticClass() == _semanticClass))
      return false;
    if(! OtherReduces(rhs))
      return false;
    if(! ThisExpands(rhs))
      return false;
    
    //if all tests pass return true
    return true;
  }
  
  public sneps3.classes.SemanticClass getSemanticClass()
  {
    return (_semanticClass);
  }  
  
  public sneps3.classes.RelationSet getRelations()
  {
    return  (_relations);
  }
    
  public sneps3.classes.NodeSet getNodes(){
    return (_nodes);
  }

  public boolean setNodes(final NodeSet ns){
    _nodes=ns;
    return(true);
  }

  public boolean checkIfInstance(final sneps3.classes.CableSet cs)
	{//if all of our relations are in the cable set return true 
		//otherwise return false
	  Iterator iterateRelations = 
		  getRelations().iterator(); 
	  //loop for each relation in the set.
    while(iterateRelations.hasNext())
		{
			 Relation nextRel = (Relation)iterateRelations.next();
			 if (cs.findCable(nextRel) != null)
				 return false;
		}
	  
    return true;
  }

  public String toString(final int level)
  {
    String ind="";
    for(int i=0; i<level; i++)
      ind+=Defaults.INDENT;
    return (ind + "Semantic Class: " + _semanticClass.toString() + '\n' + 
        "   Relations:\n" + _relations.toString(level+1));
        
  }

  public String toString(){
    return(toString(0));
  }
  
  public boolean setSemanticClass(SemanticClass semClass){
    if (_lock)
      return (false);
    _semanticClass=semClass;
    return (true);
  }
  
  public boolean setRelationSet(RelationSet rs){
    if (_lock)
      return (false);
    _relations=rs;
    return (true);
  }    
  
  public boolean lock(){
    boolean ret=_lock;
    _lock=true;
    return (ret);
  }

}
