package sneps3.corecode;
import java.util.*;

/**
 * Default implementation of the CaseFrameSet interface.
 */
class S3_CaseFrameSet implements CaseFrameSet{

  /**
   * Hashtable to store the actual case frames.
   *
   * @serial
   */
  protected java.util.Hashtable _table;
  
  /**
   * Class constructor.
   *
   * @return a new instance of this class
   */
  public S3_CaseFrameSet()
  {
    _table = new Hashtable();
  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in RelationSet.java, see        +++*/
  /*+++ that file for documentation describing these methods.            +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public boolean add(sneps3.classes.CaseFrame n)
  {
    if (_table.containsKey(((CaseFrame)n).getHash()))
      return (false);
    _table.put(((CaseFrame)n).getHash(),n);
    return (true);
  }

  public void clear()
  {
    _table.clear();
  }

  public boolean contains(sneps3.classes.CaseFrame n)
  {
    return _table.containsKey(((CaseFrame)n).getHash());
  }

  public boolean isEmpty()
  {
    return _table.isEmpty();
  }

  public CaseFrame remove(sneps3.classes.RelationSet rs)
  {
    CaseFrame cf = Defaults.FACTORY.createCaseFrame(null,rs);
    cf.setHash();
    return ((CaseFrame)_table.remove(cf.getHash()));
  }

  public int size()
  {
    return _table.size();
  }

  public Iterator iterator()
  {
    return (_table.values().iterator());
  }

  public String toString(final int level){
    String ind="";
    for (int i=0; i<level; i++)
      ind+=Defaults.INDENT;
    String ret=ind + "Case Frame Set containing:\n";
    Iterator frames=iterator();
    while (frames.hasNext())
      ret += ((CaseFrame)frames.next()).toString(level+1);
    return (ret);
  }

  public String toString(){
    return (toString(0));
  }

  public Object[] toArray(){
    return(_table.values().toArray(Defaults.FACTORY.createCaseFrameArray()));
  }

}
