package sneps3.corecode;
import java.io.*;

/**
 * Default implementation of the Context interface.
 */
class S3_Context implements Context, Serializable, Cloneable, Comparable{

  /**
   * The name of the context.
   *
   * @serial
   */
  protected String _name;

  /**
   * The set of asserted hypotheses in this context.
   *
   * @serial
   */
  protected NodeSet _hyps;

  /**
   * The set of all derrived hypotheses in this context.  Note this includes
   * all the hypotheses in <code>_hyps</code>.
   *
   * @serial
   */
  protected NodeSet _ders;

  
  /**
   * Class constructor.
   *
   * @return a new instance of this class
   */
  public S3_Context(){
    _name=null;
    _hyps=null;
    _ders=null;
  }

  public int compareTo(Object o) throws ClassCastException{
    return(getName().compareToIgnoreCase(((Context)o).getName()));
  }

  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in SemanticClass.java, see that +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public boolean isKnownInconsis(){
    return (_ders.isKnownInconsis());
  }

  public String getName(){
    return (_name);
  }

  public boolean setName(String n){
    _name=n;
    return (true);
  }

  public sneps3.classes.NodeSet getNodes(){
    return (_hyps);
  }

  public boolean setHyps(NodeSet ns){
    _hyps=ns;
    return(true);
  }

  public boolean setDers(NodeSet ns){
    _ders=ns;
    return(true);
  }

  public boolean equals(final sneps3.classes.Context rhs){
    return(_name.equalsIgnoreCase(rhs.getName()));
  }

  public boolean addNode(final sneps3.classes.Node n){
    _hyps.add(n);
    return (true);
  }
  
  public boolean removeNode(final sneps3.classes.Node n){
    _hyps.remove(n);
    return (true);
  }

  public String toString(final int level){
    String ret = "";
    for (int i=0; i<level; i++)
      ret+=Defaults.INDENT;
    ret += "Name: " + _name + "   Econtext:\n";
    if (_hyps != null)
	ret += _hyps.toString(level+1);
    return (ret);
  }

  public String toString(){
    return (_name);
  }


  /* substituted simple representation
  public String toString(){
    return (toString(0));
  }
  */

}
