package sneps3.corecode;
import java.io.*;
import java.util.*;

/**
 * Default implementation of the ContextSet interface.
 */
class S3_ContextSet implements ContextSet, Serializable, Cloneable
{

  /**
   * Hashtable to hold the contexts.
   *
   * @serial
   */
  protected Hashtable _table;


  /**
   * Class constructor.
   *
   * @return a new instance of this class
   */
  S3_ContextSet()
  {
    _table = new Hashtable();

  }

  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in SemanticClass.java, see that +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public Object clone(){
    Object ret=null;
    try{ret=super.clone();}
    catch(CloneNotSupportedException e){
      //This should never happen because the Cloneable interface IS implemented
    }
    return (ret);
  }

  public boolean add(final sneps3.classes.Context n)
  {
    if (!Defaults.CASE_SENSITIVE)
      if (_table.containsKey(n.getName().toUpperCase()))
        return (false);
      else
        _table.put(n.getName().toUpperCase(), n);
    else
      if (_table.containsKey(n.getName()))
        return (false);
    else
      _table.put(n.getName(), n);
    return (true);
  }

  public void clear()
  {
    _table.clear();
  }

  public Object[] toArray(){
    return(_table.values().toArray(Defaults.FACTORY.createContextArray()));
  }

  public boolean contains(final String name)
  {
     if (!Defaults.CASE_SENSITIVE)
      return _table.containsKey(name.toUpperCase());
    else
      return _table.containsKey(name);
  }

  public boolean isEmpty()
  {
    return _table.isEmpty();
  }

  public Context remove(final String name)
  {
    if (!Defaults.CASE_SENSITIVE)
      return ((Context)_table.remove(name.toUpperCase()));
    else
      return ((Context)_table.remove(name));
  }

  public int size()
  {
    return _table.size();
  }

  public java.util.Iterator iterator()
  {
    return (_table.values().iterator());
  }

  public String toString(final int level){
    return "";
  }

  public String toString(){
    return (toString(0));
  }

}
