package sneps3.corecode;

/**
 * Default implementation for the MolecularNode interface.
 */
class S3_MolecularNode extends S3_Node implements MolecularNode
{
  
  /**
   * The down cable set of this node.
   *
   * @serial
   */
  protected CableSet _cableSet;
  
  /**
   * The case frame of this node.
   *
   * @serial
   */
  protected CaseFrame _caseFrame;
  
  /**
   * Mutator lock.
   *
   * @serial
   */
  protected boolean _lock;

  /**
   * Class constructor.
   *
   * @return a new instance of this class
   */
  public S3_MolecularNode(){
    _cableSet=null;
    _caseFrame=null;
    _lock=false;
  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in Relation.java, see that      +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public boolean deepEquals(final sneps3.classes.Node rhs)
  {
    return super.deepEquals(rhs) &&
      ((MolecularNode) rhs).getCableSet() == _cableSet &&
      ((MolecularNode) rhs).getCaseFrame() == _caseFrame;
  }

  public sneps3.classes.CableSet getCableSet()
  {
    return _cableSet;
  }
  
  public boolean setCableSet(final CableSet cableSet)
  {
    if (!_lock){
      _cableSet  = cableSet;
      return (true);
    }
    else
      return (false);
  }
  
  public sneps3.classes.CaseFrame getCaseFrame()
  {
    return _caseFrame;
  }
  
  public boolean setCaseFrame(final CaseFrame caseFrame)
  {
    if (!_lock){
      _caseFrame = caseFrame;
      return (true);
    }
    else
      return (false);
  }
  
  public boolean isAdjustableTo(final sneps3.classes.MolecularNode mn){
    // First: check if my caseframe is adjustable to <mn>'s caseframe
    if( _caseFrame == null ||
        mn.getCaseFrame() == null ||
        ! _caseFrame.isAdjustableTo(mn.getCaseFrame()) )
      return false;

    // Second: check if my cableset is adjustable to <mn>'s cableset
    sneps3.classes.Cable c, c1;
    sneps3.classes.CableSet cs = mn.getCableSet(); 
    java.util.Iterator ci = _cableSet.iterator();
    while( ci.hasNext()){
      // get a cable from this node
      c = (Cable)ci.next();                          
      // get the corresponding cable in <mn>
      c1 = cs.findCable( c.getRelation() );   
	  if( c1 != null && ! c.isAdjustableTo(c1) )
            return false;
    }
    
    return true;
  }
  
  public String toString(final int level)
  {
    return super.toString(level) + 
      "Case frame:\n" + 
      _caseFrame.toString(level+1) + 
      "Cables: \n" +
      _cableSet.toString(level+1);
  }

  public String toString(){
    return (toString(0));
  }
  
}
