package sneps3.corecode;
import java.io.*;
import java.util.*;


/**
 * Default SNePS 3 implementation of the NodeSet interface.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
class S3_NodeSet implements NodeSet, Serializable, Cloneable{


  /**
   * A hash table to hold all the nodes in the set.
   *
   * @serial
   */
  protected Hashtable _table;


  /**
   * A marker to cache consistency information.
   *
   * @serial
   */
  protected boolean _consistent;


  /**
   * Class constructor.  Just creates a new hash table for the nodes and
   * sets the empty set to be consistent (not known to be inconsistent).
   *
   * @return the constructed node set.
   */
  public S3_NodeSet()
  {
    _table = new Hashtable();
    _consistent=true;
  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in NodeSet.java, see            +++*/
  /*+++ that file for documentation describing these methods.            +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public Object clone(){
    Object ret=null;
    try{ret=super.clone();}
    catch(CloneNotSupportedException e){
      //This should never happen because the Cloneable interface IS implemented
    }
    return (ret);
  }

  public boolean add(sneps3.classes.Node n)
  {
    if (_table.containsKey(n.getName()))
      return (false);
    _table.put(n.getName(),n);
    return (true);
  }

  public void clear()
  {
    _table.clear();
  }
  public boolean contains(sneps3.classes.Node n)
  {
    return _table.contains(n);
  }

  public boolean contains(sneps3.classes.NodeSet ns)
  {
    if( ns == null )
	return false;

    java.util.Iterator ni = ns.iterator();
    Node n;
    while(ni.hasNext()){
	n = (Node)ni.next();
	if( ! this.contains(n) )
	    return false;
    }
    return true;
  }

  public boolean equals(sneps3.classes.NodeSet ns)
  {
    if( ns == null)
	return (false);
    return (size()==ns.size() && contains(ns));
  }

  public boolean isEmpty()
  {
    return _table.isEmpty();
  }

  public boolean remove(sneps3.classes.Node n)
  {
    return (_table.remove(n.getName())!=null);
  }

  public int size()
  {
    return _table.size();
  }

  public java.util.Iterator iterator()
  {
    return (_table.values().iterator());
  }

  public String toString(int level)
  {
     String retVal = "";
     Iterator i = iterator();
     while (i.hasNext())
       retVal += ((Node)i.next()).toString(level);
     return retVal;
  }
  public String toString(){
    return (toString(0));
  }

  public boolean isKnownInconsis(){
    return (!_consistent);
  }

  public boolean setConsistent(final boolean value){
    boolean ret=_consistent;
    _consistent=value;
    return (ret);
  }

}
