package sneps3.corecode;

/**
 *Path implementation for SNePS 3
 *Data members/fields are first
 *member functions follow are are in alphabetical order
 */

class S3_Path implements sneps3.corecode.Path{


  ///////////////////////Members////////////////////////
  /**
   *should use the path type constants from this file.
   *
   *Path::UNIT_PATH means look at the base member
   *Path::COMPLEX_PATH means look at the path members
   */
  protected int pathtype;
  
  /**
   *This is the base relation for a path if path type is base then this is 
   *not null - for complex paths it is null
   */
  protected Relation base;
  /**
   *The two paths for complex relations null for a unitpath
   */
  protected Path firstPath, restPath;
  /**
   *true iff (this is a converse path or this is is a relation- style 
   * unitpath)
   */
	private boolean _converse;
  
  /**
   *locks the class against having the mutators touch private variables
   */
  protected boolean _lock;
  
  /////////////////////Methods////////////////////////////
  
  /**
   *Zero parameter constructor for the factory method
   */
  S3_Path()
  {
    _lock = false;
    //initialize the rest to null - factory will give them their correct
    //values and then lock the instance
    _converse = false;
    pathtype = UNIT_PATH;
    base = null;
    firstPath=null;
    restPath=null;
  }
  
  /**
   *Converses the cpath passed in as its parameter 
   */
  public Path converse(Path cpath)
  {
    if (pathtype == UNIT_PATH)
      //potentially dangerous casting
      ((S3_Path)cpath)._converse = !((S3_Path)cpath)._converse;
    //missing code
    return cpath;
  }
  
  /**
   *@return the value of the converse member variable
   */
  public boolean isConverse()
  {
    return _converse;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path compose(Path a, Path b, boolean f){
    return null;
  }

  /**
   * WRITE THIS METHOD!!!
   */
  public Path kstar(Path a){
    return null;
  }

  /**
   * WRITE THIS METHOD!!!
   */
  public Path kplus(Path a){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path or(Path a,Path b){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path and(Path a,Path b){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path not(Path b){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path relative_complement(Path a,Path b){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path irreflexive_restrict(Path a){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path exception(Path a,Path b){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path domain_restrict(Path a,Node b,Path c){
    return null;
  }
  
  /**
   * WRITE THIS METHOD!!!
   */
  public Path range_restrict(Path a,Path b, Node c){
    return null;
  }
  
  /**
   *@return returns a printable string representation of the path
   *@param level is a degree of indentation
   */
  public String toString(final int level)
  {
    String ret="";
    for (int i=0; i<level; i++)
      ret+=Defaults.INDENT;
    //if this path has a single relation
    if(pathtype == Path.UNIT_PATH)
      ret += ("Relation: " + base.toString());
    else //complex path
      {
        ret += ("First SubPath: " + firstPath.toString());
        ret += ("\n Second SubPath: " + restPath.toString());
      }
    return ret;
  }
  
	/**
         *@return Returns a printable string representation of the path
         */
  public String toString()
  {
    return toString(0);
  }
}
