package sneps3.corecode;
import java.io.*;
import java.util.*;


/**
 * Default SNePS 3 implementation of the RelationSet interface.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
class S3_RelationSet implements RelationSet, Serializable, Cloneable{


  /**
   * Table to hold the actual relations.
   *
   * @serial
   */
  protected Hashtable _table;


  /**
   * Class constructor.  Simply creates a new hash table to hold relations.
   *
   * @return the new relation set
   */
  public S3_RelationSet()
  {
    _table = new Hashtable();
  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in RelationSet.java, see        +++*/
  /*+++ that file for documentation describing these methods.            +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public sneps3.classes.RelationSet minus(final sneps3.classes.RelationSet rhs)
  {
    S3_RelationSet ret = new S3_RelationSet();
    Iterator ri = iterator();
    while (ri.hasNext()){
      Relation r = (Relation)ri.next();
      if (!rhs.contains(r.getName()))
        ret.add(r);
    }
    return (ret);
  }

  public sneps3.classes.Relation get(final String name){
    if (!Defaults.CASE_SENSITIVE)
      return (Relation)_table.get(name.toUpperCase());
    else
      return (Relation)_table.get(name);
  }

  public Object clone(){
    Object ret=null;
    try{ret=super.clone();}
    catch(CloneNotSupportedException e){
      //This should never happen because the Cloneable interface IS implemented
    }
    return (ret);
  }

  public boolean add(final Relation r){

    if (!Defaults.CASE_SENSITIVE)
      if (_table.containsKey(r.getName().toUpperCase()))
        return (false);
      else
        _table.put(r.getName().toUpperCase(), r);
    else
      if (_table.containsKey(r.getName()))
        return (false);
    else
      _table.put(r.getName(), r);
    return (true);
  }

  public void clear()
  {
    _table.clear();
  }

  public Object[] toArray(){
    return(_table.values().toArray(Defaults.FACTORY.createRelationArray()));
  }

  public boolean contains(final String name)
  {
    if (!Defaults.CASE_SENSITIVE)
      return _table.containsKey(name.toUpperCase());
    else
      return _table.containsKey(name);
  }

  public boolean isEmpty()
  {
    return _table.isEmpty();
  }

  public Relation remove(final String name)
  {
    if (!Defaults.CASE_SENSITIVE)
      return ((Relation)_table.remove(name.toUpperCase()));
    else
      return ((Relation)_table.remove(name));
  }

  public int size()
  {
    return _table.size();
  }

  public java.util.Iterator iterator()
  {
    return (_table.values().iterator());
  }

  public String toString(int level){
    String ret = "";
    Iterator i = iterator();
    while (i.hasNext())
      ret += ((Relation)i.next()).toString(level);
    return (ret);
  }

  public String toString(){
    return (toString(0));
  }

}

