package sneps3.corecode;

import java.io.*;
import java.util.*;


/**
 * Instances of this class are the SEMANTIC classes for SNePS 3 nodes.
 * A SNePS 3 node must have exactly one semantic class, which is used to
 * restrict the kinds of relations that may point to it. <P>
 * This is the Sneps 3 default implementation for the SemanticClass interface.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
class S3_SemanticClass implements SemanticClass, Serializable, Cloneable,
                                  Comparable{

  /**
   * Number of instances of this class that have been created.
   * @serial
   */
  protected static int _count = 0;

  /**
   * The name of this instance.  All instances must have a unique name.
   *
   * @serial 
   */
  protected String _name;

  /**
   * The parent of this instance.  Only the root of the tree may have value of
   * <code>null</code> for this field. <P>
   * Note: Only the parent of the instance is stored.  This means a parent
   * has no direct access to its children.
   * It is assumed that the environment will store the tree in some other
   * data structure, like a HashTable, and use that to perform efficient
   * searches.
   * 
   * @serial 
   */
  protected SemanticClass _parent;

  /**
   * The semantic classes with this one as parent.
   * Should be modified only at network level using addChild and removeChild
   * for proper management.
   *
   * @serial
   */
  protected SemanticClassSet _children;

  /**
   * Set of nodes that have this semantic class.
   *
   * @serial
   */
  protected NodeSet _nodes;

  /**
   * Set of relations that have this semantic class.
   *
   * @serial
   */
  protected RelationSet _relations;

  /**
   * Set of case frames that have this semantic class.
   *
   * @serial
   */
  protected CaseFrameSet _caseFrames;

  /**
   * Display color for this semantic class.
   *
   * @serial
   */
  protected java.awt.Color _color;

  /**
   * @serial
   */
  protected int _depth;
  
  /**
   * Unique identifier for each built instance. Cloned instances may still
   * share this value though.
   *
   * @serial
   */
  protected int _id;

  /**
   * Access lock for the mutators.  Mutators may only operate when this field
   * is set to <code>false</code>.
   *
   * @serial
   */
  protected boolean _lock;


  /**
   * The class constructor.  Fields will be set with mutators after
   * construction.
   *
   * @return an empty instance
   */
  S3_SemanticClass(){
    _name=null;
    _parent=null;
    _nodes=null;
    _relations=null;
    _caseFrames=null;
    _color=java.awt.Color.lightGray;
    _lock=false;
    _id=_count++;
  }

  
  /**
   * This method modifies the class counter if semantic classes are read in
   * from the serializable interface.  It tries to make sure loading new
   * semantic classes in with old ones won't violate the unique
   * identifiers.  ID values are reset as though it were a new semantic class
   * were being created.
   *
   * @param in the object input stream the semantic class is being read from
   */
  private void readObject(ObjectInputStream in)
    throws IOException, ClassNotFoundException {
    in.defaultReadObject();
    _id=_count++;
  }


  /**
   * Compares semantic classes based on their name.  Makes this class
   * comparable.
   *
   * @param o the semantic class to be compared with this instance
   * @return the value of <code>compareToIgnoreCase</code> on the two
   *  semantic classes' name strings
   */
  public int compareTo(Object o) throws ClassCastException{

    if (_depth<((SemanticClass)o).getDepth())
      return (Integer.MIN_VALUE);
    else if (_depth>((SemanticClass)o).getDepth())
      return (Integer.MAX_VALUE);
    
    if (!Defaults.CASE_SENSITIVE)
      return (getName().compareToIgnoreCase(((SemanticClass)o).getName()));
    else return (getName().compareTo(((SemanticClass)o).getName()));

  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in SemanticClass.java, see that +++*/
  /*+++ file for documentation describing these methods.                 +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public sneps3.classes.SemanticClass getRoot(){
    if (_parent==null)
      return (this);
    else
      return (_parent.getRoot());
  }

  public boolean setChildren(final SemanticClassSet children){
    _children = children;
    return (true);
  }

  public sneps3.classes.SemanticClassSet getChildren(){
    return (_children);
  }

  public boolean hasChildren(){
    return (!_children.isEmpty());
  }

  public boolean addChild(final SemanticClass child){
    return (_children.add(child));
  }

  public boolean removeChild(final String child){
    return (_children.remove(child)!=null);
  }

  public boolean isa(final sneps3.classes.SemanticClass ancestor){
    if (equals(ancestor))
      return (true);
    else if (_parent==null)
      return (false);
    else
      return (_parent.isa(ancestor));
  }

  public String getName(){
    return (_name);
  }

  public sneps3.classes.SemanticClass getParent(){
    return (_parent);
  }

  public sneps3.classes.NodeSet getNodes(){
    return (_nodes);
  }

  public sneps3.classes.RelationSet getRelations(){
    return (_relations);
  }

  public sneps3.classes.CaseFrameSet getCaseFrames(){
    return (_caseFrames);
  }

  public java.awt.Color getColor(){
    return (_color);
  }

  public boolean setName(String name){
    if (_lock)
      return (false);
    else{
      _name = name;
      return (true);
    }
  }

  public boolean setParent(final SemanticClass parent){
    if (_lock)
      return (false);
    else {
      _parent = parent;
      return (true);
    }
  }

  public boolean setNodes(final NodeSet ns){
    _nodes=ns;
    return(true);
  }

  public boolean setRelations(final RelationSet rs){
    _relations=rs;
    return(true);
  }

  public boolean setCaseFrames(final CaseFrameSet cfs){
    _caseFrames=cfs;
    return(true);
  }

  public boolean setColor(final java.awt.Color color){
    _color=color;
    return (true);
  }

  public boolean equals(final sneps3.classes.SemanticClass rhs){
    if (!Defaults.CASE_SENSITIVE)
      return(_name.compareToIgnoreCase(rhs.getName())==0);
    else
      return(_name.compareTo(rhs.getName())==0);
  }

  public SemanticClass deepClone(){
    S3_SemanticClass ret = new S3_SemanticClass(); 
    ret._name = new String(_name);
    if (_parent!=null)
      ret._parent = _parent.deepClone();
    return (ret);
  }

  public String toString(final int level){
    String ret="";
    for(int i=0; i<level; i++)
      ret+=Defaults.INDENT;
    if (_parent==null)
      ret+="Root Node Class: " + _name;
    else
      ret+="Node Class: " + _name + " \t\tParent: " + _parent.getName();
    return (ret);
  }

  public boolean setDepth(){
    if (_parent == null)
      _depth = 0;
    else
      _depth = _parent.getDepth()+1;
    return (true);
  }

  public int getDepth(){
    return (_depth);
  }

  /** supressed to create a simpler model
  public String toString(){
    return (toString(0));
  }
  */

  public String toString(){
    return (getName());
  }

  public boolean lock(){
    boolean ret=_lock;
    _lock=true;
    return (ret);
  }

}
