package sneps3.corecode;

import java.io.*;
import java.util.*;


/**
 * Default SNePS 3 implementation of the SemanticClassSet interface.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
class S3_SemanticClassSet implements SemanticClassSet, Serializable,
  Cloneable{


  /**
   * Table to hold the actual semantic classes.
   *
   * @serial
   */
  protected Hashtable _table;


  /**
   * Class constructor.  Simply creates a new hash table to hold semantic
   * classes.
   *
   * @return the new semantic class set
   */
  public S3_SemanticClassSet(){
    _table=new Hashtable();
  }


  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
  /*+++                                                                  +++*/
  /*+++ Remaining methods are prototyped in SemanticClassSet.java, see   +++*/
  /*+++ that file for documentation describing these methods.            +++*/
  /*+++                                                                  +++*/
  /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

  public Object clone(){
    Object ret=null;
    try{ret=super.clone();}
    catch(CloneNotSupportedException e){
      //This should never happen because the Cloneable interface IS implemented
    }
    return (ret);
  }

  public Object[] toArray(){
    return
      (_table.values().toArray(Defaults.FACTORY.createSemanticClassArray()));
  }

  public boolean add(final SemanticClass sc){
    if (!Defaults.CASE_SENSITIVE)
      if (_table.containsKey(sc.getName().toUpperCase()))
        return (false);
      else
        _table.put(sc.getName().toUpperCase(), sc);
    else
      if (_table.containsKey(sc.getName()))
        return (false);
    else
      _table.put(sc.getName(), sc);
    return (true);
  }

  public SemanticClass remove(final String name){
    if (!Defaults.CASE_SENSITIVE)
      return ((SemanticClass)_table.remove(name.toUpperCase()));
    else
      return ((SemanticClass)_table.remove(name));
  }

  public boolean isEmpty(){
    return _table.isEmpty();
  }

  public int size(){
    return _table.size();
  }

  public void clear(){
    _table.clear();
  }

  public boolean contains(String name){
    if (!Defaults.CASE_SENSITIVE)
      return (_table.containsKey(name.toUpperCase()));
    else
      return (_table.containsKey(name));
  }
  
  public sneps3.classes.SemanticClass get(final String name){
    if (!Defaults.CASE_SENSITIVE)
      return ((SemanticClass)_table.get(name.toUpperCase()));
    else
      return ((SemanticClass)_table.get(name));
  }

  public Iterator iterator(){

    return (_table.values().iterator());
  }

  public String toString(int level){
    String ind="";
    for (int i=0; i<level; i++)
      ind+=Defaults.INDENT;
    String ret = ind+"SemanticClassSet containing:\n";
    Iterator i = iterator();
    while (i.hasNext())
      ret += ((SemanticClass)i.next()).toString(level+1) + '\n';
    return (ret);
  }

  public String toString(){
    return(toString(0));
  }

}
