package sneps3.corecode;
import java.util.*;

public class S3_SnepsFactory implements SnepsFactory{

  public SemanticClass createSemanticClass(String name,
      sneps3.classes.SemanticClass parent){
    SemanticClass retVal = new S3_SemanticClass();
    retVal.setName(name);
    retVal.setParent((SemanticClass)parent);
    retVal.setNodes(new S3_NodeSet());
    retVal.setRelations(new S3_RelationSet());
    retVal.setCaseFrames(new S3_CaseFrameSet());
    retVal.setChildren(new S3_SemanticClassSet());
    retVal.setDepth();
    retVal.lock();
    return retVal;
  }
  
  public SemanticClass createSemanticClass(String name,
      sneps3.classes.SemanticClass parent, java.awt.Color color){
    SemanticClass ret = createSemanticClass(name, parent);
    ret.setColor(color);
    return (ret);
  }

  public SemanticClass[] createSemanticClassArray(){
    return (new S3_SemanticClass []{});
  }

  public SemanticClassSet createSemanticClassSet(){
    return (new S3_SemanticClassSet());
  }

  public Relation[] createRelationArray(){
    return (new S3_Relation []{});
  }

  public CaseFrame[] createCaseFrameArray(){
    return (new S3_CaseFrame []{});
  }

  public RelationSet createRelationSet(){
    return new S3_RelationSet();
  }

  public CaseFrameSet createCaseFrameSet(){
    return (new S3_CaseFrameSet());
  }

  public ContextSet createContextSet(){
    return (new S3_ContextSet());
  }

  public Context[] createContextArray(){
    return (new S3_Context []{});
  }

  public Relation createRelation(String name,
      sneps3.classes.SemanticClass semClass, int adjustType, int adjustLimit)
  {
    Relation r = new S3_Relation();
    r.setName(name);
    r.setType((SemanticClass)semClass);
    r.setAdjust(adjustType);
    r.setLimit(adjustLimit);
    r.setNodes(new S3_NodeSet());
    r.setCaseFrames(new S3_CaseFrameSet());
    r.setPaths(new S3_PathSet());
    r.lock();
    return r;
  }
  
  public NodeSet createNodeSet(){
    return new S3_NodeSet();
  }

  public Cable createCable(sneps3.classes.Relation r,
      sneps3.classes.NodeSet ns)
  {
    Cable c = new S3_Cable();
    c.setRelation((Relation)r);
    c.setNodeSet((NodeSet)ns);
    Iterator nodes=ns.iterator();
    while(nodes.hasNext())
      ((NodeSet)r.getNodes()).add((Node)nodes.next());
    c.lock();
    return c;
  }

  public CableSet createCableSet()
  {
    return new S3_CableSet();
  }
  
  public BaseNode createBaseNode(String name,
      sneps3.classes.SemanticClass semClass)
  {
    BaseNode b = new S3_BaseNode();
    
    b.setSemanticClass((SemanticClass)semClass);
    //make sure that the name is meaningful
    if(name.trim().equals(""))
      b.setName(b. defaultName());
    else
      b.setName(name);
    ((NodeSet)semClass.getNodes()).add(b);
    b.lock();
    return b;
  }

  public MolecularNode createMolecularNode(String name,
      sneps3.classes.SemanticClass semClass, sneps3.classes.CableSet cableSet,
      sneps3.classes.CaseFrame caseFrame)
  {
    //kludge
    return (new S3_MolecularNode());
    /*
    MolecularNode m = new S3_MolecularNode();
    m.setName(name);
    m.setSemanticClass(semClass);
    semClass.getNodes().add(m);
    m.setCableSet(cableSet);

    // set this node as parent of all the cables
    Iterator cables = cableSet.iterator();
    while(cables.hasNext())
      ((Cable)cables.next()).setRoot(m);

    m.setCaseFrame(caseFrame);
    caseFrame.getNodes().add(m);
    m.lock();
    return m;
  */
  }

  public sneps3.classes.Network createNetwork()
  {
     return (new S3_Network());
  }

  public CaseFrame createCaseFrame(sneps3.classes.SemanticClass semClass,
      sneps3.classes.RelationSet rs){
    CaseFrame ret=new S3_CaseFrame();
    ret.setRelationSet((RelationSet)rs);
    ret.setSemanticClass((SemanticClass)semClass);
    ret.lock();
    ret.setHash();
    ret.setNodes(new S3_NodeSet());
    return (ret);
  }

  public Context createContext(String n){
    Context ret = new S3_Context();
    ret.setName(n);
    ret.setHyps(createNodeSet());
    ret.setDers(createNodeSet());
    return (ret);
  }
  
}
