package sneps3.corecode;
import java.io.*;
import java.util.*;

/**
 * Up cable sets are special cases meant to provide all the backwards links
 * from a node.  It breaks all kinds of rules (multiple cables of same
 * relation, different root nodes for each cable, etc).
 */

class S3_UpCableSet extends S3_CableSet implements CableSet, Serializable,
                                                   Cloneable{

  public S3_UpCableSet(){
    _table=new Hashtable();
  }

  /**
   * Adds a cable to the set.  Up cables don't follow any of the normal
   * conventions, so it is simply added.
   *
   * @param c the cable to be added to the set.
   * @return the added cable, null if no cable added.
   */
  public boolean add(final Cable c){
    _table.put(c.getRelation().getName(),c);
    return(true);
  }

  // The remaining methods are inherited from S3_CableSet.

}



