package sneps3.corecode;


/**
 * The public interface for semantic node class definitions.
 * Every SNePS 3 node must be given a semantic class recognized by the system.
 * Semantic classes are used by the inference mechanism.  Semantic classes
 * have an initial semantic taxonomy, which may be extended by the knowledge
 * engineer.<P>
 * SemanticClass instances each represent one of these semantic classes, so
 * every SNePS 3 node will be associated with exactly one SemanticClass
 * instance.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface SemanticClass extends sneps3.classes.SemanticClass{


  /**
   * Name mutator.
   *
   * @param n the string to be the new name of this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setName(final String name);


  /**
   * Nodes mutator.
   *
   * @param ns the new node set for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setNodes(final NodeSet ns);


  /**
   * Relations mutator.
   *
   * @param rs the new relation set for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setRelations(final RelationSet rs);


  /**
   * CaseFrames mutator.
   *
   * @param cfs the new case frame set for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setCaseFrames(final CaseFrameSet cfs);


  /**
   * Parent mutator.
   *
   * @param parent the semantic class that is to be the new parent of this
   *  instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setParent(final SemanticClass parent);

    
  /**
   * Color mutator.
   *
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setColor(final java.awt.Color color);

  
  /**
   * Children mutator.
   *
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setChildren(final SemanticClassSet scs);

  boolean setDepth();

  /**
   * Returns a wholely distinct version of this instance.  The purpose is to
   * provide security managers a way to give copies of its data without
   * granting direct access to its own private copies.
   *
   * WARNING! The deepClone methods can explode memory usage and will
   * create duplicate instances of (possibly unique) objects, so use it
   * only when absolutely necessary or as a temporary measure.  This may
   * change in the future if the Serializable interface is used to generate
   * the copied data.
   *
   * @return a copy of this instance
   */
  SemanticClass deepClone();


  /**
   * Locks object against mutation.
   *
   * @return a boolean representing the previous status of the lock
   */
  boolean lock();

}
