package sneps3.corecode;

import sneps3.exception.UniqueException;

/**
 * Interface for sets of semantic classes.
 * Set interfaces are created in SNePS 3 to provide provide the power of
 * control over how costly set operations are done, while hiding such
 * implementation details from higher levels.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface SemanticClassSet extends sneps3.classes.SemanticClassSet{


  /**
   * Add a semantic class to this set.
   *
   * @param semClass the semantic class to be added
   * @return <code>true</code> if the semantic class was added,
   *  <code>false</code> otherwise
   */
  boolean add(final SemanticClass sc);


  /**
   * Remove a semantic class from this set.
   *
   * @param name the name of the semantic class to be removed
   * @return <code>true</code> if the semantic class was removed,
   *  <code>false</code> otherwise.
   */
  SemanticClass remove(final String name);


  /**
   * Remove all semantic classes from this set.
   */
  void clear();


}
