package sneps3.exception;

/**   
 * This exception is thrown whenever a network attempts to discard an
 * instance that is still being used by another object.
 */

public class InUseException extends SnepsException{

  /**
   * @serial
   */
  public Object _violator;
  /**
   * @serial
   */
  public Object _violated;

  public InUseException(){
    super("Object is still in use.");
    _violator=_violated=null;
  }

  public InUseException(final Object violator, final Object violated){
    super("In use exception occured trying to remove " +
        violator.getClass().getName() + " \"" + violator.toString() +
        "\" which is still being referenced by " +
        violated.getClass().getName() + " \"" + violated.toString() + "\".");
    _violator=violator;
    _violated=violated;
  }
}
