package sneps3.exception;

/**   
 * This exception is thrown on an attempt to use an undefined object.
 */

public class OutOfBoundsException extends SnepsException{

  /**
   * @serial
   */
  public Object _violator;

  public OutOfBoundsException(){
    super("A value was out of bounds.");
    _violator=null;
  }

  public OutOfBoundsException(final Object violator){
    super("A value set in " + violator.getClass().getName() + " \"" +
        violator.toString() + "\" was out of bounds.");
    _violator=violator;
  }

}
