package sneps3.exception;

/**   
 * This exception is thrown whenever an error occurs in the structure
 * of an object.
 */

public class StructureException extends SnepsException{

  /**
   * @serial
   */
  public Object _violator;
  /**
   * @serial
   */
  public Object _violated;

  public StructureException(){
    super("There was an error in the structure");
    _violator=_violated=null;
  }

  public StructureException(final Object violator, final Object violated){
    super("Invalid structure access in " + violated.getClass().getName() +
        " \"" + violated.toString() + "\" around " +
        violator.getClass().getName() + " \"" + violator.toString() + "\"");
    _violator=violator;
    _violated=violated;
  }

  public StructureException(final String msg){
    super(msg);
  }

}
