package sneps3.exception;

/**   
 * This exception is thrown on an attempt to use an undefined object.
 */

public class UndefinedException extends SnepsException{

  /**
   * @serial
   */
  public Object _violator;

  public UndefinedException(){
    super("Attempt to use an undefined object.");
    _violator=null;
  }

  public UndefinedException(final Object violator){
    super("Attempt to use " + violator.getClass().getName() + " \"" +
        violator.toString() + "\" which is not yet defined.");
    _violator=violator;
  }

}
