package sneps3.exception;

/**   
 * This exception is thrown whenever a second instance of a unique class
 * appears.
 */

public class UniqueException extends SnepsException{

  /**
   * @serial
   */
  public Object _violator;
  /**
   * @serial
   */
  public Object _violatedSet;

  public UniqueException(){
    super("A uniqueness violation has occured.");
    _violator=_violatedSet=null;
  }

  public UniqueException(final Object violator, final Object violatedSet){
    super("Uniquness exception occured trying to add " +
        violator.getClass().getName()+ " \"" + violator.toString() +
        "\" to a set it already exists in.");
    _violator=violator;
    _violatedSet=violatedSet;
  }

}
