package sneps3.snip;
import sneps3.classes.*;
import java.util.*;
/**
 * The public interface for the SNIP class
 * This class will carry out SNePS mental actions, such as deducing or
 *  asserting.
 */

public interface SNIP
{

    /**
     * This method will return a SNIP object
     * @param theNetwork The network that the SNIP object will operate upon
     */
     SNIP SNIP(Network theNetwork);

    /**
     * This method will build a node
     * @param caseFrame The case frame to be used as the node's case frame
     * @param cableSet A set of cables that agree with the caseFrame
     * @return The node object that was built
     */
      public Node build(CaseFrame caseFrame, CableSet cableSet);
    
    /**
     * This method will deduce whether the given node 'holds' or should be
     *  believed in the specified context
     * @param Node The exact pattern of cables to be deduced, specified as a
     *              fully built node
     * @param contextName A string containing the name of the context where the
     *              node should be deduced
     * @return The node that was deduced, or 'null' if the deduction failed
     */
      public Node deduce(Node nodeToDeduce, String contextName);
    
    /**
     * This method will assert a node in the current context of the network
     * @param Node The exact pattern of cables to be deduced, specified as a
     *              fully built node
     * @param forwardChain a boolean variable indicating whether forward
     *        chaining inference should be done on the newly asserted
     *        information
     * @return The node that was deduced, or 'null' if the deduction failed
     */
      public Node assert(Node nodeToAssert, boolean forwardChain);

    /**
     * This method will turn inference tracing on or off
     * @param trace A boolean value indicating whether to turn inference
     *               tracing on (true) or off(false)
     */
      public void SetTracingMode(boolean trace);

    /**
     * This method will allow a path to be defined for Path-Based inference
     * @param newPath The new path to be defined
     */
      public void DefinePath(Path path);

    /**
     * This method will undefine a path
     * @param pathName The name of the path to be undefined
     */
      public void UndefinePath(String pathName);

    /**
     * This method will get a list of all currently defined paths
     * @return A PathSet object containing references to Path objects
     *           representing all currently defined paths
     */
  //Needed?
  //      public PathSet GetPaths();

    /**
     * This method will remove all defined paths
     */
      public void ClearPaths();
}
