package sneps3.spine;
/**<PRE>
 * Using BNF, NOT EBNF, so parens are terminals of the grammar
 * // Grammar for commands
 * G  ::= C | (C) | (C)G
 * // Command (partial listing)
 * C  ::= ON | IN | IT | DM | S | R | F | CB | N ...
 * // Outnet
 * ON ::= outnet FN
 * // Innet
 * IN ::= innet FN
 * // Intext
 * IT ::= FN
 * // Demo
 * DM ::= demo | demo FN | demo FN BOOL | demo FN BOOL old
 *
 * // Semantic Class Name
 * SN ::= NAMESTRING
 * // Semantic Class
 * S  ::= SN | sem SN | ...
 *
 * // Relation Name
 * RN ::= NAMESTRING
 * // Relation
 * R  ::= RN | define RN S AN I | ...
 * // Relation Set
 * RS ::= R | RS R | ...
 *
 * // Case Frame
 * F  ::= S RS | frame S RS | ...
 *
 * //Cable
 * CB :: = R NS | ...
 * // Cable Set
 * CS ::= CB | CS CB

 * // Node Name
 * NN ::= NAMESTRING
 * // Node
 * N  ::= BN | MN | VN | ...
 * // Base Node
 * BN ::= NN | build BN | ...
 * // Molecular Node
 * MN ::= NN | build MN | assert MN | ...
 * // Variable Node
 * VN ::= NN | build NN | ...
 *</PRE>
 */
public abstract class SnepsulParser{

  /**
   * G
   * Evaluate each paren-seperated section "str" and for each try:
   * C(str, port);
   */
  public boolean parse(final String commands, TelePort port){
    return (true);
  }

  /**
   * try ON(c, port) then IN(c, port) then IT(c, port) etc.
   */
  private boolean C(final String c, TelePort port){
    return (true);
  }

  /**
   * ON
   * Get first token, if not "outnet" the return false
   * otherwise, try to open second token as a OutputFileStream o, 
   * if that was successful, then call port.outnet(o)
   */
  private boolean ON(final String on, TelePort port){
    return (true);
  }

}
