package sneps3.spine;

import sneps3.exception.*;
import sneps3.classes.*;
import sneps3.mind.*;

import java.util.Iterator;

/**
 * This class provides direct access to the methods of a created OpenMind
 * instance.
 */
public class TelePort
{
  
    /**
     * This variable holds a reference to a Java SNePS Network object that
     * is used by the GUI to add relations and case frames to, etc.
     */
  protected OpenMind _mind;

  /**
   * Creates a new SnepsProxy object to act as a liason between a GUI and
   * the back end Java SNePS code.
   */
  public TelePort()
  {
    _mind = new OpenMind();
  }

    /** 
     * This method adds a semantic class with the given name and parent
     * to the network.  The 'wait' parameter is not currently used.
     */
  public SemanticClass defineSemanticClass(String semClassName, 
				 String semClassParent) throws SnepsException
  {
    return(_mind._network.defineSemanticClass(semClassName, semClassParent));
  }

  public void undefineSemanticClass(String semClassName) throws SnepsException{
    _mind._network.undefineSemanticClass(semClassName);
  }

  public void setSemanticClassColor(String semClassName, java.awt.Color color)
    throws SnepsException{
    _mind._network.setSemanticClassColor(semClassName, color);
  }
  
  /**
   * This method adds a relation to the network with the given relation
   * name, semantic class, adjust type and adjust limit.
   */
  public Relation defineRelation(String relationName, String semClassName, 
      String adjustType, int adjustArg) throws SnepsException
  {
      return(_mind._network.defineRelation(relationName, semClassName,
          adjustType, adjustArg));
  }

  public void undefineRelation(String relationName) throws SnepsException{
    _mind._network.undefineRelation(relationName);
  }

  /**
   * This method returns a String array containing the names of all 
   * semantic classes that are currently defined in the network
   */
  public SemanticClassSet getSemanticClasses()
  {
      return(_mind._network.getSemanticClasses());
  }

  /** 
   * This class returns a String array containing the names of all 
   * relations that are currently defined within the network.
   */
  public RelationSet getRelations()
  {
     return (_mind._network.getRelations());
  }
  
  /**
   * This method adds a case frame to the network consisting of the
   * relations named in the String array 'relations' parameter, with
   * the semantic class named by semClassName
   */
  public CaseFrame defineCaseFrame(String semClassName, String[] relations)
    throws SnepsException
  {
    return (_mind._network.defineCaseFrame(semClassName, relations));
  }

  public void undefineCaseFrame(String[] relations)throws SnepsException{
    _mind._network.undefineCaseFrame(relations);
  }

  public Context defineContext(String name) throws SnepsException{
    return(_mind._network.addContext(name));
  }

  public void undefineContext(String name) throws SnepsException{
    _mind._network.removeContext(name);
  }

  public void setDefaultContext(String name) throws SnepsException{
    _mind._network.setDefaultContext(name);
  }

  public CaseFrameSet getCaseFrames(){
    return (_mind._network.getCaseFrames());
  }

  public ContextSet getContexts(){
    return (_mind._network.getContexts());
  }

	public void addNetworkListener(NetworkListener l){
		_mind.addNetworkListener(l);
	}
	
	public void removeNetworkListener(NetworkListener l){
		_mind.removeNetworkListener(l);
	}

  /**
   * This method returns a String representation of the contents of the 
   * network, suitable for printing.
   */
/*  public String getNetworkContents()
  {
    return _mind._network.toString();
  }
*/
	/**
	 *this method interfaces between the GUI and the SNePS corecode to 
	 *build a base node
	 *@param NodeName the name for the node, it may be an empty
         * string in which case a default name will be generated
	 *@param SemClassName the name of the semantic class for this node
	 */
  /*	public String addBaseNode(String NodeName, String SemClassName)
	{
		//the factory will take care of providing a default name if the 
		//user didn't give a name
		
		//retrieve the semantic class of the node
		SemanticClass sem = 
			_mind._network.findSemanticClassByName(SemClassName);
		//create the node
		BaseNode newNode = Defaults.FACTORY.createBaseNode(NodeName, sem);
		//try to add it to the network
		if(_mind._network.addNode(newNode))
			return "added Node to the Network";
		else
			return "problem adding node";
	}
  */					  
}
