package sneps3.world.gui;

import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Iterator;

/**
 */
class BuildingBoxFrame extends JInternalFrame{

  /**
   * @serial
   */
  protected JPanel _display;
  /**
   * @serial
   */
  protected GUI _mainFrame;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected Toolkit _toolkit;
  /**
   * @serial
   */
  protected JComboBox _semClass;
  /**
   * @serial
   */
  protected JComboBox _context;

  /**
   * @serial
   */
  protected JTextField _nameValue;

  /**
   * @serial
   */
  protected boolean _clearCheck;

  public BuildingBoxFrame(GUI mainFrame, TelePort port,
      int x, int y, int w, int h){
    super("Building Box", true, false, true, false);

    _mainFrame = mainFrame;
    _port=port;
    _toolkit = Toolkit.getDefaultToolkit();
    
   _clearCheck = true;

    _context = new JComboBox();
    SemanticClass[] sca=(SemanticClass[])_port.getSemanticClasses().toArray();
    java.util.Arrays.sort(sca);
    _semClass = new JComboBox(sca);
 
    _nameValue = new JTextField();

    JButton commitButton = new JButton("Commit");

    JButton clearButton = new JButton("Clear");
    
		ButtonGroup buildGroup = new ButtonGroup();
	
		final JRadioButton baseButton = new JRadioButton("Base Node");
		buildGroup.add(baseButton);
	
		final JRadioButton valueButton = new JRadioButton("Value Node");
		buildGroup.add(valueButton);

		final JRadioButton molecularButton = new JRadioButton("Molecular Node");
		buildGroup.add(molecularButton);
	
		JButton addButton = new JButton("Add");
    	addButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
        	if (baseButton.isSelected()){
          	addNode(new GraphNode((SemanticClass)_semClass.getSelectedItem(),
          										_nameValue.getText(), null,0));
					}
          else if (valueButton.isSelected())
          	addNode(new GraphNode((SemanticClass)_semClass.getSelectedItem(), null,
          										_nameValue.getText(),1));
          else if (molecularButton.isSelected())
          	addNode(new GraphNode(null, _nameValue.getText(), null,2));
        }
      });

		JButton removeButton = new JButton("Remove");
    JButton assertButton = new JButton("Assert");

    getContentPane().setLayout(new BorderLayout());
    
    JPanel panel = new JPanel();
		
    panel.setLayout(new GridLayout(0,1));

		panel.add(commitButton);
    panel.add(clearButton);
    panel.add(addButton);

		panel.add(baseButton);
		panel.add(valueButton);
		panel.add(molecularButton);
	
    panel.add(new JLabel("Semantic Class"));
    panel.add(_semClass);
    panel.add(new JLabel("Name/Value"));
    panel.add(_nameValue);

    panel.add(removeButton);
    panel.add(assertButton);

    getContentPane().add(panel, BorderLayout.EAST);

		_display = new JPanel();
		_display.setLayout(new LazyLayout());
		getContentPane().add(new JScrollPane(_display), BorderLayout.CENTER);

    pack();
    setBounds(x,y,w,h);

  }
  
  void addNode(JComponent node){
		_display.add(node);
  }

  void scUpdate(int type, SemanticClass sc){
 		_semClass.removeAllItems();
    SemanticClass[] sca =
      (SemanticClass [])_port.getSemanticClasses().toArray();
    java.util.Arrays.sort(sca);
    for(int i=0; i<java.lang.reflect.Array.getLength(sca); i++)
      _semClass.addItem(sca[i]);
    _semClass.validate();
	}

  void rUpdate(int type, Relation r){
  }

  void cfUpdate(int type, CaseFrame cf){
  }

  void ctUpdate(int type, Context ct){
  }

  void nUpdate(int type, Node n){
  }

  void scSelect(int clicks, SemanticClass sc){
		_semClass.setSelectedItem(sc);
  }
  
}
