package sneps3.world.gui;

import sneps3.exception.*;
import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 */
class CaseFrameFrame extends JInternalFrame{

  /**
   * @serial
   */
  protected JList _relsIn;
  /**
   * @serial
   */
  protected JList _relsOut;
  /**
   * @serial
   */
  protected DefaultListModel _pool;
  /**
   * @serial
   */
  protected DefaultListModel _pile;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected JComboBox _semClass;
  /**
   * @serial
   */
  protected static final String _name = "Case Frames";
  /**
   * @serial
   */
  protected Toolkit _toolkit;
  /**
   * @serial
   */
  protected GUI _mainFrame;
  /**
   * @serial
   */
  protected CaseFramePanel _framesPanel;

  public CaseFrameFrame(GUI mainFrame, TelePort port,
      int x, int y, int w, int h){
    super(_name, true, false, true, false);
    _port=port;
    _mainFrame = mainFrame;
    _framesPanel = new CaseFramePanel(this, port);
    _toolkit = Toolkit.getDefaultToolkit();

    _pool = new DefaultListModel();
    _relsOut = new JList(_pool);
    Relation[] rels = (Relation[])_port.getRelations().toArray();
    java.util.Arrays.sort(rels);
    for (int i=0; i<java.lang.reflect.Array.getLength(rels); i++)
      _pool.addElement(rels[i]);

    _pile = new DefaultListModel();
    _relsIn = new JList(_pile);

    SemanticClass[] sca=(SemanticClass[])_port.getSemanticClasses().toArray();
    java.util.Arrays.sort(sca);
    _semClass = new JComboBox(sca);

    JLabel scLabel = new JLabel("Semantic Class");

    JLabel rLabel = new JLabel("Relations:");

    JLabel chooseLabel = new JLabel("Choices:");

    JButton addButton = new JButton("Add");
    addButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          _framesPanel.add();
          clear();
        }
      });
        
    JButton removeButton = new JButton("Remove");
    removeButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          _framesPanel.remove();
        }
      });

    JButton expandButton = new JButton("Expand");
    expandButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          _framesPanel.expand();
        }
      });

    JButton clearButton = new JButton("Clear All");
    clearButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          clear();
        }
      });

    JButton arrowButton1 = new JButton("->");
    arrowButton1.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          Relation selected = (Relation)_relsIn.getSelectedValue();
          if (selected==null){
            _toolkit.beep();
          }
          _pile.removeElement(selected);

          _pool.removeAllElements();
          Relation[] rels=(Relation[])_port.getRelations().toArray();
          java.util.Arrays.sort(rels);
          for(int i=0; i<java.lang.reflect.Array.getLength(rels); i++)
            if (!_pile.contains(rels[i]))
              _pool.addElement(rels[i]);

          _relsIn.validate();
          _relsOut.validate();
        }
      });

    JButton arrowButton2 = new JButton("<-");
    arrowButton2.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          Relation selected = (Relation)_relsOut.getSelectedValue();
          if (selected==null){
            _toolkit.beep();
            return;
          }
          _pool.removeElement(selected);
          _pile.addElement(selected);

          _relsIn.validate();
          _relsOut.validate();
        }
      });

    GridBagLayout gridbag = new GridBagLayout();
    getContentPane().setLayout(gridbag);
    GridBagConstraints c = new GridBagConstraints();
    c.fill = GridBagConstraints.BOTH;

    c.gridx = 0;
    c.gridy = 0;
    c.weighty = 1;
    c.gridwidth = GridBagConstraints.REMAINDER;
    JScrollPane cfp = new JScrollPane(_framesPanel);
    gridbag.setConstraints(cfp, c);
    getContentPane().add(cfp);
    c.gridwidth = 1;
    c.weighty = 0;

    c.gridx = 0;
    c.gridy = 1;
    c.gridwidth = GridBagConstraints.REMAINDER;
    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(1,0));
    panel.add(addButton);
    panel.add(expandButton);
    panel.add(removeButton);
    gridbag.setConstraints(panel,c);
    getContentPane().add(panel);
    c.gridwidth = 1;

    c.gridx = 0;
    c.gridy = 2;
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(scLabel,c);
    getContentPane().add(scLabel);
    c.gridwidth = 1;
    
    c.gridx = 0;
    c.gridy = 3;
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(_semClass, c);
    getContentPane().add(_semClass);
    c.gridwidth = 1;

    c.gridx = 0;
    c.gridy = 4;
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(clearButton, c);
    getContentPane().add(clearButton);
    c.gridwidth = 1;

    c.gridx = 0;
    c.gridy = 5;
    gridbag.setConstraints(rLabel, c);
    getContentPane().add(rLabel);

    c.gridx = 1;
    c.gridy = 5;
    gridbag.setConstraints(chooseLabel, c);
    getContentPane().add(chooseLabel, c);

    c.gridx = 0;
    c.gridy = 6;
    gridbag.setConstraints(arrowButton1, c);
    getContentPane().add(arrowButton1);

    c.gridx = 1;
    c.gridy = 6;
    gridbag.setConstraints(arrowButton2, c);
    getContentPane().add(arrowButton2, c);

    c.gridx = 0;
    c.gridy = 7;
    c.weightx = 1;
    c.weighty = 1;
    JScrollPane rip = new JScrollPane(_relsIn);
    gridbag.setConstraints(rip,c);
    getContentPane().add(rip);
    c.weighty = 0;
    c.weightx = 0;

    c.gridx = 1;
    c.gridy = 7;
    c.weightx = 1;
    c.weighty = 1;
    JScrollPane rop = new JScrollPane(_relsOut);
    gridbag.setConstraints(rop,c);
    getContentPane().add(rop);
    c.weighty = 0;
    c.weightx = 0;

    pack();
    setBounds(x,y,w,h);
  }

  void clear(){
    _pile.removeAllElements();
    _pool.removeAllElements();
    Relation[] rels=(Relation[])_port.getRelations().toArray();
    java.util.Arrays.sort(rels);
    for(int i=0; i<java.lang.reflect.Array.getLength(rels); i++)
      _pool.addElement(rels[i]);
    _relsIn.validate();
    _relsOut.validate();

  }

  void scSelect(final int clicks, final SemanticClass sc){
    _semClass.setSelectedItem(sc);
  }

  void scUpdate(final int type, final SemanticClass sc){
    _semClass.removeAllItems();
    SemanticClass[] sca =
      (SemanticClass [])_port.getSemanticClasses().toArray();
    java.util.Arrays.sort(sca);
    for(int i=0; i<java.lang.reflect.Array.getLength(sca); i++)
      _semClass.addItem(sca[i]);
    _semClass.validate();
  }

  void rSelect(final int clicks, final Relation r){
    if (clicks==1){
      if (_pool.contains(r))
        _relsIn.setSelectedValue(r,true);
      else
        _relsOut.setSelectedValue(r,true);
    }
  }

  void rUpdate(final int type, final Relation r){
    if (type == -1){
      if (_pile.contains(r))
        _pile.removeElement(r);
      else
        _pool.removeElement(r);
    }
    else if (type == 1){
      _pool.removeAllElements();
      Relation[] rels = (Relation[])_port.getRelations().toArray();
      java.util.Arrays.sort(rels);
      for (int i=0; i<java.lang.reflect.Array.getLength(rels); i++)
        _pool.addElement(rels[i]);
      _relsOut.validate();
    }
  }

  void cfUpdate(final int change, final CaseFrame cf){
    _framesPanel.refresh();
    validate();
  }

  public String toString(){
    return (_name);
  }

}
