package sneps3.world.gui;

import sneps3.exception.*;
import sneps3.spine.*;
import sneps3.classes.*;

import java.util.Iterator;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class CaseFramePanel extends JPanel{

  /**
   * @serial
   */
  protected CaseFrameFrame _parent;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected MyPanel _selected;
  /**
   * @serial
   */
  protected Color _on, _off;
  /**
   * @serial
   */
  protected Toolkit _toolkit;

  CaseFramePanel(CaseFrameFrame parent, TelePort port){
    _parent = parent;
    _port = port;
    _selected = null;
    _on = (new
      javax.swing.plaf.metal.MetalLookAndFeel()).getTextHighlightColor();
    _off = Color.white;
    _toolkit = Toolkit.getDefaultToolkit();
    refresh();
    
  }

  void refresh(){
    removeAll();
    CaseFrame [] cfa = (CaseFrame[])_port.getCaseFrames().toArray();
    if (java.lang.reflect.Array.getLength(cfa)==0){
      repaint();
      return;
    }
    java.util.Arrays.sort(cfa);
    javax.swing.border.Border border = BorderFactory.createEtchedBorder();

    for(int i=0; i<java.lang.reflect.Array.getLength(cfa); i++){
      CaseFrame cur = cfa[i];
      JPanel temp = new MyPanel(cur);
      temp.setBorder(border);

      temp.setLayout(new BoxLayout(temp,BoxLayout.Y_AXIS));
      temp.add(new JLabel("("+cur.getSemanticClass().getName()+")"));
      temp.add(new JLabel(" "));
      Relation[] ra = (Relation[])cur.getRelations().toArray();
      java.util.Arrays.sort(ra);
      for(int j=0; j<java.lang.reflect.Array.getLength(ra); j++){
        temp.add(new JLabel(ra[j].toString()));
      }
      temp.setBackground(_off);
      temp.addMouseListener(new MouseAdapter() {
          public void mouseClicked(MouseEvent e){
            if (_selected != null){
              _selected.setBackground(_off);
            }
            _selected = (MyPanel)e.getComponent();
            _selected.setBackground(_on);
          }
        });
      add(temp);
      int size = getComponentCount();
      GridLayout layout = new
        GridLayout((new Double((Math.ceil(Math.sqrt(size))))).intValue(),
          (new Double(Math.ceil(Math.sqrt(size)))).intValue());
      setLayout(layout);
      validate();
    }
  }

  void add(){
    String scName =
      ((SemanticClass)_parent._semClass.getSelectedItem()).getName();
    Object[] rels = _parent._pile.toArray();
    String[] rNames = new String[_parent._pile.size()];
    for (int i=0; i<_parent._pile.size(); i++)
      rNames[i] = ((Relation)rels[i]).getName();
    CaseFrame cf = null;
    try{
      cf=_port.defineCaseFrame(scName, rNames);
    }
    catch (SnepsException e){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, e, "Error",
          JOptionPane.WARNING_MESSAGE);
    }
    
    if (cf!=null)
      _parent._mainFrame.cfUpdate(1,cf);
  }

  void remove(){
    // unusual operation, can afford to be inefficient
    if (_selected==null){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, "No case frame selected.",
          "Error", JOptionPane.WARNING_MESSAGE);
      return;
    }
    RelationSet rs = _selected.getCF().getRelations();
    String[] rels = new String[rs.size()];
    Relation[] ra = (Relation[])rs.toArray();
    for (int i=0; i<rs.size(); i++)
      rels[i]=ra[i].getName();
    try {
      _port.undefineCaseFrame(rels);
      _parent._mainFrame.cfUpdate(-1,_selected.getCF());
      _selected = null;
    }
    catch (SnepsException e){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, e, "Error",
          JOptionPane.WARNING_MESSAGE);
    }
  }

  void expand(){
    if (_selected==null){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent,
          "No case frame selected.",
          "Error", JOptionPane.WARNING_MESSAGE);
      return;
    }
    _parent._pool.removeAllElements();
    Relation[] rels = (Relation [])
      _port.getRelations().toArray();
    java.util.Arrays.sort(rels);
    for (int i=0; i<java.lang.reflect.Array.getLength(rels); i++)
      _parent._pool.addElement(rels[i]);
    
    _parent._pile.removeAllElements();          
    _parent._semClass.setSelectedItem(_selected.getCF().getSemanticClass());
    rels = (Relation[])_selected.getCF().getRelations().toArray();
    for (int i=0; i<java.lang.reflect.Array.getLength(rels); i++){
      _parent._pool.removeElement(rels[i]);
      _parent._pile.addElement(rels[i]);
    }
  }
  
  class MyPanel extends JPanel{

  /**
   * @serial
   */
    protected CaseFrame _cf;

    MyPanel(CaseFrame cf){
      super();
      _cf = cf;
    }

    CaseFrame getCF(){
      return (_cf);
    }

  }

}
