package sneps3.world.gui;

import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 */
class ContextFrame extends JInternalFrame{

  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected GUI _mainFrame;
  /**
   * @serial
   */
  protected ContextList _contexts;
  /**
   * @serial
   */
  protected JTextField _nameField;

  public ContextFrame(GUI mainFrame, TelePort port,
      int x, int y, int w, int h){
    super("Contexts", true, false, true, false);

    _mainFrame = mainFrame;

    JLabel nameLabel = new JLabel("Name");
    JLabel knownLabel = new JLabel("Known-");
    JLabel inconsisLabel = new JLabel("Inconsistent");

    _nameField = new JTextField(10);

    JTextField kiField = new JTextField(10);
    kiField.setEditable(false);

    _contexts = new ContextList(this, port, kiField);

    _contexts.addMouseListener(new MouseAdapter(){
        public void mouseClicked(MouseEvent e){
          _mainFrame.ctSelect(e.getClickCount(),
              (Context)_contexts._list.getSelectedValue());
        }
      });

    JButton addButton = new JButton("Add");
    addButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          _contexts.addContext(_nameField.getText());
          _nameField.setText("");
        }
      });

    JButton removeButton = new JButton("Remove");
    removeButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          _contexts.removeContext();
        }
      });

    JButton setButton = new JButton ("Set As Default");
    setButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          _contexts.setDefaultContext();
        }
      });

    GridBagLayout gridbag = new GridBagLayout();
    getContentPane().setLayout(gridbag);
    GridBagConstraints c = new GridBagConstraints();
    c.fill = GridBagConstraints.BOTH;

    // 1
    c.gridx = 0;
    c.gridy = 0;
    gridbag.setConstraints(nameLabel, c);
    getContentPane().add(nameLabel);

    // 2
    c.gridx = 1;
    c.gridy = 0;
    c.gridheight = 2;
    gridbag.setConstraints(addButton, c);
    getContentPane().add(addButton);
    c.gridheight = 1;

    // 3
    c.gridx = 0;
    c.gridy = 1;
    c.weightx = 1;
    gridbag.setConstraints(_nameField, c);
    getContentPane().add(_nameField);
    c.weightx = 0;

    // 4
    c.gridx = 0;
    c.gridy = 2;
    c.gridheight = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(_contexts, c);
    getContentPane().add(_contexts);
    c.gridheight = 1;

    // 5
    c.gridx = 1;
    c.gridy = 2;
    gridbag.setConstraints(removeButton, c);
    getContentPane().add(removeButton);
    
    // 6
    c.gridx = 1;
    c.gridy = 3;
    gridbag.setConstraints(setButton, c);
    getContentPane().add(setButton);


    // 7
    c.gridx = 1;
    c.gridy = 4;
    gridbag.setConstraints(knownLabel, c);
    getContentPane().add(knownLabel);

    // 8
    c.gridx = 1;
    c.gridy = 5;
    gridbag.setConstraints(inconsisLabel, c);
    getContentPane().add(inconsisLabel);

    // 9
    c.gridx = 1;
    c.gridy = 6;
    gridbag.setConstraints(kiField, c);
    getContentPane().add(kiField);

    pack();
    setBounds(x,y,w,h);
  }

  void scUpdate(int type, SemanticClass sc){
  }

  void rUpdate(int type, Relation r){
  }

  void cfUpdate(int type, CaseFrame cf){
  }

  void ctUpdate(int type, Context ct){
    _contexts.refresh();
  }

  void nUpdate(int type, Node n){
  }

  void scSelect(SemanticClass sc){
  }
  
}
