package sneps3.world.gui;

import sneps3.exception.*;
import sneps3.classes.*;
import sneps3.spine.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

class ContextList extends JScrollPane{

  /**
   * @serial
   */
  protected JList _list;
  /**
   * @serial
   */
  protected DefaultListModel _listModel;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected JTextField _kiField;
  /**
   * @serial
   */
  protected Toolkit _toolkit;
  /**
   * @serial
   */
  protected ContextFrame _parent;

  ContextList(ContextFrame parent, TelePort port, JTextField kiField){
    super();
    _parent = parent;
    _port = port;
    _kiField = kiField;
    _toolkit = Toolkit.getDefaultToolkit();
    _list = new JList();
    _list.getSelectionModel().setSelectionMode(
      ListSelectionModel.SINGLE_SELECTION);
    _listModel = new DefaultListModel();
    _list.setModel(_listModel);
    getViewport().setView(_list);

    _list.addListSelectionListener(new ListSelectionListener(){
        public void valueChanged(ListSelectionEvent e){
          Context current = (Context)_list.getSelectedValue();
          if (current == null){
            _kiField.setText("");
            return;
          }
          _kiField.setText(current.isKnownInconsis()?"Yes":"No");
        }
      });

    
    refresh();
  }

  void refresh(){
    _listModel.clear();

    Context [] cta = (Context [])_port.getContexts().toArray();
    java.util.Arrays.sort(cta);

    for (int i=0; i<java.lang.reflect.Array.getLength(cta); i++)
      _listModel.addElement(cta[i]);
    if (_list.getSelectedValue()==null){
      _kiField.setText("");
    }
    _list.validate();
  }

  void addContext(final String name){
    Context ret=null;
    if (name.length()==0){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent.getContentPane(),
      "Invalid name for context.",
      "Error", JOptionPane.WARNING_MESSAGE);
      return;
    }
    try {
      ret = _port.defineContext(name);
    }
    catch (SnepsException e) {
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, e, "Error",
          JOptionPane.WARNING_MESSAGE);
      return;
    }
    _parent._mainFrame.ctUpdate(1,ret);
  }

  void removeContext(){
    Context selected = (Context)_list.getSelectedValue();
    if (selected==null){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, "Select a context to remove.",
          "Error", JOptionPane.WARNING_MESSAGE);
      return;
    }
    try{
      _port.undefineContext(selected.getName());
    } catch (SnepsException e) {
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, e, "Error",
          JOptionPane.WARNING_MESSAGE);
      return;
    }
    _parent._mainFrame.ctUpdate(-1, selected);
  }

  void setDefaultContext(){
    Context selected = (Context)_list.getSelectedValue();
    if (selected==null){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent,
          "Select a context to set as default.",
          "Error", JOptionPane.WARNING_MESSAGE);
      return;
    }
    try{
      _port.setDefaultContext(selected.getName());
    } catch (SnepsException e) {
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, e, "Error",
          JOptionPane.WARNING_MESSAGE);
      return;
    }
  }    

}
