package sneps3.world.gui;

import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * A GUI that will run as either an applet or an application.
 */
public class GUI extends JApplet implements ActionListener, ItemListener{

  // menu bar strings
  /**
   * @serial
   */
  protected static final String _fileString = "File";
  /**
   * @serial
   */
  protected static final String _editString = "Edit";
  /**
   * @serial
   */
  protected static final String _viewString = "View";
  /**
   * @serial
   */
  protected static final String _windowString = "Window";
  /**
   * @serial
   */
  protected static final String _helpString = "Help";

  // File menu item choice strings
  /**
   * @serial
   */
  protected static final String _newString = "New Network";
  /**
   * @serial
   */
  protected static final String _openString = "Open...";
  /**
   * @serial
   */
  protected static final String _saveString = "Save";
  /**
   * @serial
   */
  protected static final String _saveasString = "Save As...";
  /**
   * @serial
   */
  protected static final String _printString = "Print...";
  /**
   * @serial
   */
  protected static final String _exitString = "Exit";

  // View menu choice strings (also the names of sub-windows)
  /**
   * @serial
   */
  protected static final String _scString = "Semantic Classes";
  /**
   * @serial
   */
  protected static final String _rString = "Relations";
  /**
   * @serial
   */
  protected static final String _cfString = "Case Frames";
  /**
   * @serial
   */
  protected static final String _ctString = "Contexts";
  /**
   * @serial
   */
  protected static final String _nString = "Network";
  /**
   * @serial
   */
  protected static final String _snebrString = "SNeBR";
  /**
   * @serial
   */
  protected static final String _snipString = "SNIP";
  /**
   * @serial
   */
  protected static final String _spineString = "SPINE";
  /**
   * @serial
   */
  protected static final String _bbString = "Building Box";
  /**
   * @serial
   */
  protected static final String _snepsulString = "SNePSUL";

  // Additional view menu choice strings
  /**
   * @serial
   */
  protected static final String _allString = "all";
  /**
   * @serial
   */
  protected static final String _noneString = "none";

  // indicates if this program is being run as an applet or not
  /**
   * @serial
   */
  protected boolean _isApplet;

  // main window of the applet or application
  /**
   * @serial
   */
  protected static JDesktopPane _mainPane;

  // sub-windows
  /**
   * @serial
   */
  protected SemanticClassFrame _scFrame;
  /**
   * @serial
   */
  protected RelationFrame _rFrame;
  /**
   * @serial
   */
  protected CaseFrameFrame _cfFrame;
  /**
   * @serial
   */
  protected ContextFrame _ctFrame;
  /**
   * @serial
   */
  protected BuildingBoxFrame _bbFrame;
  /**
   * @serial
   */
  protected NetworkFrame _nFrame;

  // port for network operations
  /**
   * @serial
   */
  protected TelePort _port;

  // current default save file
  /**
   * @serial
   */
  protected java.io.File _saveFile;

  // true if no changes have been made to the network since the last save
  /**
   * @serial
   */
  protected boolean _saved;

  // constructor
  public GUI(){
    super();

    try{
      UIManager.setLookAndFeel(
        UIManager.getCrossPlatformLookAndFeelClassName());
    } catch (Exception e) { }

    _saveFile = null;
    _saved = true;

    _port = new sneps3.spine.TelePort();

    _mainPane = new JDesktopPane();
    setContentPane(_mainPane);
    
    paneinit();
    validate();
}

  public void destroy(){
    super.destroy();
  }

  void paneinit(){
    int x1=0;
    int x2=280;
    int x3=750;
    int y1=0;
    int y2=176;
    int y3=605;

    _scFrame = new SemanticClassFrame(this,_port,x1,y1,x2-x1,y2-y1);
    _mainPane.add(_scFrame);

    _rFrame = new RelationFrame(this, _port, x2,y1,x3-x2,y2-y1);
    _mainPane.add(_rFrame);

    _cfFrame = new CaseFrameFrame(this, _port,x1,y2,x2-x1,y3-y2);
    _mainPane.add(_cfFrame);

    _ctFrame = new ContextFrame(this, _port,x1,y1,x2-x1,y2-y1);
    _mainPane.add(_ctFrame);

    _bbFrame = new BuildingBoxFrame(this, _port, x2, y2, x3-x3, y3-y2);
    _mainPane.add(_bbFrame);

    _nFrame = new NetworkFrame(this, _port, x2, y2, x3-x2, y3-y2);
    _mainPane.add(_nFrame);
    
    _bbFrame = new BuildingBoxFrame(this, _port, x2, y2, x3-x2, y3-y2);
    _mainPane.add(_bbFrame);
    
  }


  void menuinit(JFrame frame){
    JMenuBar myMenuBar = new JMenuBar();
    frame.setJMenuBar(myMenuBar);

    JMenu fileMenu = new JMenu(_fileString);
    fileMenu.setMnemonic(KeyEvent.VK_F);
    fileMenu.getAccessibleContext().setAccessibleDescription(
      "File operations");
    myMenuBar.add(fileMenu);
    
    JMenu editMenu = new JMenu(_editString);
    editMenu.setMnemonic(KeyEvent.VK_E);
    editMenu.getAccessibleContext().setAccessibleDescription(
   		"Edit operations");
   	myMenuBar.add(editMenu);

    JMenu viewMenu = new JMenu(_viewString);
    viewMenu.getAccessibleContext().setAccessibleDescription(
      "View operations");
    viewMenu.setMnemonic(KeyEvent.VK_V);
    myMenuBar.add(viewMenu);

    JMenu windowMenu = new JMenu(_windowString);
    windowMenu.getAccessibleContext().setAccessibleDescription(
      "Window operations");
    windowMenu.setMnemonic(KeyEvent.VK_W);
    myMenuBar.add(windowMenu);

    JMenu helpMenu = new JMenu(_helpString);
    helpMenu.getAccessibleContext().setAccessibleDescription(
      "Help operations");
    helpMenu.setMnemonic(KeyEvent.VK_H);
    myMenuBar.add(helpMenu);

    JMenuItem menuItem;

    menuItem = new JMenuItem(_newString, KeyEvent.VK_N);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N,
        ActionEvent.CTRL_MASK));
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Create a blank network");
    menuItem.addActionListener(this);
    fileMenu.add(menuItem);

    menuItem = new JMenuItem(_openString, KeyEvent.VK_O);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O,
        ActionEvent.CTRL_MASK));
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Load a new network from a file");
    menuItem.addActionListener(this);
    fileMenu.add(menuItem);

    menuItem = new JMenuItem(_saveString, KeyEvent.VK_S);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,
        ActionEvent.CTRL_MASK));
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Save current network");
    menuItem.addActionListener(this);
    fileMenu.add(menuItem);

    menuItem = new JMenuItem(_saveasString, KeyEvent.VK_A);
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Save current network to a specified file");
    menuItem.addActionListener(this);
    fileMenu.add(menuItem);

    fileMenu.addSeparator();

    menuItem = new JMenuItem(_printString, KeyEvent.VK_P);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P,
        ActionEvent.CTRL_MASK));
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Brings up printing dialog");
    menuItem.addActionListener(this);
    fileMenu.add(menuItem);

    fileMenu.addSeparator();

    menuItem = new JMenuItem(_exitString, KeyEvent.VK_X);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,
        ActionEvent.CTRL_MASK));
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Close and exit program");
    menuItem.addActionListener(this);
    fileMenu.add(menuItem);

    JCheckBoxMenuItem cbMenuItem;

    cbMenuItem = new JCheckBoxMenuItem(_scString);
    cbMenuItem.setMnemonic(KeyEvent.VK_S);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_rString);
    cbMenuItem.setMnemonic(KeyEvent.VK_R);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_cfString);
    cbMenuItem.setMnemonic(KeyEvent.VK_F);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_3,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_ctString);
    cbMenuItem.setMnemonic(KeyEvent.VK_C);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_4,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_nString);
    cbMenuItem.setMnemonic(KeyEvent.VK_T);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_5,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_snebrString);
    cbMenuItem.setMnemonic(KeyEvent.VK_N);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_6,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_snipString);
    cbMenuItem.setMnemonic(KeyEvent.VK_P);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_7,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_spineString);
    cbMenuItem.setMnemonic(KeyEvent.VK_I);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_8,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_bbString);
    cbMenuItem.setMnemonic(KeyEvent.VK_B);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_9,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    cbMenuItem = new JCheckBoxMenuItem(_snepsulString);
    cbMenuItem.setMnemonic(KeyEvent.VK_U);
    cbMenuItem.addItemListener(this);
    cbMenuItem.setState(true);
    cbMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_0,
        ActionEvent.CTRL_MASK));
    viewMenu.add(cbMenuItem);

    viewMenu.addSeparator();

    menuItem = new JMenuItem(_allString, KeyEvent.VK_A);
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Sets all windows visible");
    menuItem.addActionListener(this);
    menuItem.addItemListener(this);
    viewMenu.add(menuItem);

    menuItem = new JMenuItem(_noneString, KeyEvent.VK_N);
    menuItem.getAccessibleContext().setAccessibleDescription(
      "Sets all windows to not visible");
    menuItem.addActionListener(this);
    menuItem.addItemListener(this);
    viewMenu.add(menuItem);
    
    menuItem = new JMenuItem(_scString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_1,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_rString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_2,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_cfString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_3,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_ctString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_4,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_nString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_5,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_snebrString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_6,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_snipString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_7,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_spineString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_8,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_bbString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_9,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
    
    menuItem = new JMenuItem(_snepsulString);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_0,
    	ActionEvent.ALT_MASK));
    menuItem.addActionListener(this);
    windowMenu.add(menuItem);
        
  }

  public void actionPerformed(ActionEvent e){
    JMenuItem source = (JMenuItem)(e.getSource());

    if (source.getText().compareTo(_newString)==0)
      //create new network
      ;

    else if (source.getText().compareTo(_openString)==0)
      // open network file
      ;

    else if (source.getText().compareTo(_saveString)==0)
      // save network
      ;

    else if (source.getText().compareTo(_saveasString)==0)
      // save dialog
      ;

    else if (source.getText().compareTo(_printString)==0)
      //print dialog
      ;

    else if (source.getText().compareTo(_exitString)==0)
      closeProgram();

    else if (source.getText().compareTo(_scString)==0)
      _scFrame.validate();
    
  }

  public void itemStateChanged(ItemEvent e){
    JMenuItem source = (JCheckBoxMenuItem)(e.getItem());

    if (source.getText().compareTo(_scString)==0){
      if (e.getStateChange()==ItemEvent.SELECTED)
        _scFrame.setVisible(true);
      else if (e.getStateChange()==ItemEvent.DESELECTED)
        _scFrame.setVisible(false);
    }

    else if (source.getText().compareTo(_rString)==0){
      if (e.getStateChange()==ItemEvent.SELECTED)
        _rFrame.setVisible(true);
      else if (e.getStateChange()==ItemEvent.DESELECTED)
        _rFrame.setVisible(false);
    }

    else if (source.getText().compareTo(_cfString)==0){
      if (e.getStateChange()==ItemEvent.SELECTED)
        _cfFrame.setVisible(true);
      else if (e.getStateChange()==ItemEvent.DESELECTED)
        _cfFrame.setVisible(false);
    }

    else if (source.getText().compareTo(_nString)==0){
      if (e.getStateChange()==ItemEvent.SELECTED)
        _nFrame.setVisible(true);
      else if (e.getStateChange()==ItemEvent.DESELECTED)
        _nFrame.setVisible(false);
    }

    else if (source.getText().compareTo(_ctString)==0){
      if (e.getStateChange()==ItemEvent.SELECTED)
        _ctFrame.setVisible(true);
      else if (e.getStateChange()==ItemEvent.DESELECTED)
        _ctFrame.setVisible(false);
    }
        
    else if (source.getText().compareTo(_bbString)==0){
      if (e.getStateChange()==ItemEvent.SELECTED)
        _bbFrame.setVisible(true);
      else if (e.getStateChange()==ItemEvent.DESELECTED)
        _bbFrame.setVisible(false);
    }

  }

  protected void closeProgram(){
    System.exit(0);
  }

  // signal handling for semantic class selection
  void scSelect(final int clicks, final SemanticClass sc){
    _rFrame.scSelect(clicks, sc);
    _cfFrame.scSelect(clicks, sc);
    _bbFrame.scSelect(clicks, sc);
  }

  // signal handling for semantic class updates
  void scUpdate(final int change, final SemanticClass sc){
    _saved = false;
    _scFrame.scUpdate(change, sc);
    _rFrame.scUpdate(change, sc);
    _cfFrame.scUpdate(change, sc);
    _bbFrame.scUpdate(change, sc);
  }

  // signal handling for relation selection
  void rSelect(final int clicks, final Relation r){
    _cfFrame.rSelect(clicks, r);
  }

  // signal handling for relation updates
  void rUpdate(final int change, final Relation r){
    _saved = false;
    _rFrame.rUpdate(change,r);
    _cfFrame.rUpdate(change,r);
  }

  // signal handling for case frame selection
  void cfSelect(final int clicks, final CaseFrame cf){
  }

  // signal handling for case frame updates
  void cfUpdate(final int change, final CaseFrame cf){
    _cfFrame.cfUpdate(change,cf);
  }

  // signal handling for context selection
  void ctSelect(final int clicks, final Context ct){
  }

  // signal handling for context updates
  void ctUpdate(final int change, final Context ct){
    _ctFrame.ctUpdate(change,ct);
  }

  // any shared cleanup of both applet and application version
  void terminate(){
  }    

  public static void main(String[] args){

    JFrame frame = new JFrame("Java SNePS 3.0");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    final GUI myGUI = new GUI();
    myGUI.menuinit(frame);
    frame.setContentPane(myGUI._mainPane);
    frame.setVisible(true);
    frame.setSize(758,656);
	frame.validate();

    Runtime.getRuntime().addShutdownHook(new Thread() {
        public void run() {
          myGUI.terminate();
          System.out.println("SNePS 3 Terminated.");
        }
      });

  }
}
