package sneps3.world.gui;

import sneps3.exception.*;
import sneps3.spine.*;
import sneps3.classes.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;

class GraphNode extends JEditorPane
	implements MouseMotionListener, MouseListener{
	
  /**
   * @serial
   */
	Vector _cables;
  /**
   * @serial
   */
	SemanticClass _semClass;
  /**
   * @serial
   */
	String _name;
  /**
   * @serial
   */
	Object _value;
  /**
   * @serial
   */
	int _mx, _my;
	
	GraphNode() {
		super();
		_semClass = null;
		_name = "";
		_value = null;
		addMouseListener(this);
		addMouseMotionListener(this);
		
	}
	
	GraphNode(SemanticClass sc, String name, Object value, int type) {
		this();
		setDoubleBuffered(true);
		_semClass = sc;
		_name = name;
		_value = value;
		setBackground(sc.getColor());
		setEditable(false);
		setBounds(0,0,30,30);
		if (type==0){
			setText(_name);
			setBorder(new javax.swing.border.LineBorder(java.awt.Color.black));
		}
	}
	
	public boolean isDoubleBuffered(){
		return (true);
	}
	
	public void mouseClicked(MouseEvent e){
	}
	
	public void mouseEntered(MouseEvent e){
	}

	public void mouseExited(MouseEvent e){
	}
	
	public void mousePressed(MouseEvent e){
		_mx=e.getX();
		_my=e.getY();
	}
	
	public void mouseReleased(MouseEvent e){
	}

	public void mouseDragged(MouseEvent e){
		setLocation(getX()+e.getX()-_mx,getY()+e.getY()-_my);
	}
	
	public void mouseMoved(MouseEvent e){
	}

}

