package sneps3.world.gui;

import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 */
class NetworkFrame extends JInternalFrame{

  /**
   * @serial
   */
  protected JPanel _display;
  /**
   * @serial
   */
  protected GUI _mainFrame;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected Toolkit _toolkit;
  /**
   * @serial
   */
  protected JComboBox _context;
  /**
   * @serial
   */
  protected JComboBox _semClass;
  /**
   * @serial
   */
  protected JCheckBox _showall;
  /**
   * @serial
   */
  protected JCheckBox _assert;
  /**
   * @serial
   */
  protected JTextField _name;
  /**
   * @serial
   */
  protected JTextField _slot1;
  /**
   * @serial
   */
  protected JTextField _slot2;
  /**
   * @serial
   */
  protected JTextField _slot3;

  public NetworkFrame(GUI mainFrame, TelePort port,
      int x, int y, int w, int h){
    super("Network", true, false, true, false);

    _mainFrame = mainFrame;
    _display = new JPanel();
    _port=port;
    _toolkit = Toolkit.getDefaultToolkit();
    _context = new JComboBox();
    _semClass = new JComboBox();
    _showall = new JCheckBox();
    _assert = new JCheckBox();
    _name = new JTextField();
    _slot1 = new JTextField(2);
    _slot2 = new JTextField(2);
    _slot3 = new JTextField(2);

    JButton removeButton = new JButton("Remove");

    JButton buildButton = new JButton("Build");

    getContentPane().setLayout(new BorderLayout());

    getContentPane().add(_display, BorderLayout.CENTER);

    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(0,1));
    panel.add(new JLabel("Default"));
    panel.add(new JLabel("Context"));
    panel.add(_context);
    JPanel panel2 = new JPanel();
    panel2.add(_showall);
    panel2.add(new JLabel("Show All"));
    panel.add(panel2);
    JPanel panel3 = new JPanel();
    panel3.add(_assert);
    panel3.add(new JLabel("Auto-assert"));
    panel.add(panel3);
    panel.add(removeButton);
    panel.add(new JLabel("Semantic Class"));
    panel.add(_semClass);
    panel.add(new JLabel("Name"));
    panel.add(_name);
    panel.add(new JLabel("Slots:"));
    JPanel panel4 = new JPanel();
    panel4.setLayout(new GridLayout(1,0));
    panel4.add(_slot1);
    panel4.add(new JLabel("1"));
    panel4.add(_slot2);
    panel4.add(new JLabel("2"));
    panel4.add(_slot3);
    panel4.add(new JLabel("3"));
    panel.add(panel4);
    getContentPane().add(panel, BorderLayout.EAST);

    pack();
    setBounds(x,y,w,h);

  }

  void scUpdate(int type, SemanticClass sc){
  }

  void rUpdate(int type, Relation r){
  }

  void cfUpdate(int type, CaseFrame cf){
  }

  void ctUpdate(int type, Context ct){
  }

  void nUpdate(int type, Node n){
  }

  void scSelect(SemanticClass sc){
  }
  
}
