package sneps3.world.gui;

import sneps3.exception.*;
import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 */
class RelationFrame extends JInternalFrame{

  /**
   * @serial
   */
  protected RelationList _listPanel;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected JTextField _nameField;
  /**
   * @serial
   */
  protected JComboBox _typeField;
  /**
   * @serial
   */
  protected JComboBox _adjustField;
  /**
   * @serial
   */
  protected JTextField _limitField;
  /**
   * @serial
   */
  protected Toolkit _toolkit;
  /**
   * @serial
   */
  protected static final String _name = "Relations";
  /**
   * @serial
   */
  protected GUI _mainFrame;

  public RelationFrame(GUI mainFrame, TelePort port,
      int x, int y, int w, int h){
    super(_name, true, false, true, false);
    _port = port;
    _mainFrame = mainFrame;
    _toolkit = Toolkit.getDefaultToolkit();

    JLabel nameLabel = new JLabel("Name");
    JLabel typeLabel = new JLabel("Type");
    JLabel adjustLabel = new JLabel("Adjust");
    JLabel limitLabel = new JLabel("Limit");
    JLabel typeLabel2 = new JLabel("Type");
    JLabel adjustLabel2 = new JLabel("Adjust");
    JLabel limitLabel2 = new JLabel("Limit");

    JLabel selectLabel = new JLabel("Selected Relation Data:");

    _nameField = new JTextField(10);

    SemanticClass[] sca=(SemanticClass[])_port.getSemanticClasses().toArray();
    java.util.Arrays.sort(sca);
    _typeField = new JComboBox(sca);

    _limitField = new JTextField(10);

    String[] values = {"Expand", "None", "Reduce"};
    _adjustField = new JComboBox(values);
    _adjustField.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          JComboBox cb = (JComboBox)e.getSource();
          String choice = (String)cb.getSelectedItem();
          if (choice.compareToIgnoreCase("None")==0){
            _limitField.setEditable(false);
            _limitField.setText("");
          }
          else
            _limitField.setEditable(true);
        }
      });
    _adjustField.setSelectedIndex(1);    

    JTextField typeField2 = new JTextField(10);
    typeField2.setEditable(false);
    JTextField adjustField2 = new JTextField(10);
    adjustField2.setEditable(false);
    JTextField limitField2 = new JTextField(10);    
    limitField2.setEditable(false);

    _listPanel = new RelationList(this, port, typeField2, adjustField2,
        limitField2);

    _listPanel.addMouseListener(new MouseAdapter(){
        public void mouseClicked(MouseEvent e){
          _mainFrame.rSelect(e.getClickCount(),
              (Relation)_listPanel._list.getSelectedValue());
        }
      });

    JPanel pathPanel = new JPanel();

    JButton removeButton = new JButton("Remove");
    removeButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          _listPanel.removeSelectedRelation();
        }
      });

    JButton addButton = new JButton("Add");
    addButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          Relation created=null;
          if (_nameField.getText().length()==0){
            _toolkit.beep();
            JOptionPane.showMessageDialog(getContentPane(),
                "Invalid name for relation.",
                "Error", JOptionPane.WARNING_MESSAGE);
            return;
          }
          if (_typeField.getSelectedItem()==null){
            _toolkit.beep();
            JOptionPane.showMessageDialog(getContentPane(),
                "Invalid type.",
                "Error", JOptionPane.WARNING_MESSAGE);
            return;
          }
          try{
            if (_adjustField.getSelectedItem().toString().compareTo("None")==0)
              created = _port.defineRelation(
                _nameField.getText(),
                _typeField.getSelectedItem().toString(),
                "None", -1);
            else
              created = _port.defineRelation(
                _nameField.getText(),
                _typeField.getSelectedItem().toString(),
                _adjustField.getSelectedItem().toString(),
                java.lang.Integer.parseInt(_limitField.getText()));
          }
          catch (SnepsException exception) { 
            _toolkit.beep();
            JOptionPane.showMessageDialog(getContentPane(),
                exception, "Error", JOptionPane.WARNING_MESSAGE);
          }
          if (created != null){
            _mainFrame.rUpdate(1,created);
            _nameField.setText("");
          }        
        }
      });

    JButton pathButton = new JButton("Edit Path");
    pathButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e){
          // set path dialoge
        }
      });


    GridBagLayout gridbag = new GridBagLayout();
    getContentPane().setLayout(gridbag);
    GridBagConstraints c = new GridBagConstraints();
    c.fill = GridBagConstraints.BOTH;

    // 1
    c.gridx = 0;
    c.gridy = 0;
    gridbag.setConstraints(nameLabel,c);
    getContentPane().add(nameLabel);

    // 2
    c.gridx = 1;
    c.gridy = 0;
    gridbag.setConstraints(typeLabel,c);
    getContentPane().add(typeLabel);

    // 3
    c.gridx = 2;
    c.gridy = 0;
    gridbag.setConstraints(adjustLabel,c);
    getContentPane().add(adjustLabel);

    // 4
    c.gridx = 3;
    c.gridy = 0;
    gridbag.setConstraints(limitLabel,c);
    getContentPane().add(limitLabel);

    // 5
    c.gridx = 4;
    c.gridy = 0;
    c.gridheight = 2;
    gridbag.setConstraints(addButton, c);
    getContentPane().add(addButton);
    c.gridheight = 1;

    // 6
    c.gridx = 0;
    c.gridy = 1;
    c.weightx = 1;
    gridbag.setConstraints(_nameField,c);
    getContentPane().add(_nameField);
    c.weightx = 0;

    // 7
    c.gridx = 1;
    c.gridy = 1;
    gridbag.setConstraints(_typeField,c);
    getContentPane().add(_typeField);

    // 8
    c.gridx = 2;
    c.gridy = 1;
    gridbag.setConstraints(_adjustField,c);
    getContentPane().add(_adjustField);

    // 9
    c.gridx = 3;
    c.gridy = 1;
    gridbag.setConstraints(_limitField,c);
    getContentPane().add(_limitField);

    // 10
    c.gridx = 0;
    c.gridy = 2;
    c.gridheight = GridBagConstraints.REMAINDER;
    c.weightx = 1;
    c.weighty = 1;
    gridbag.setConstraints(_listPanel, c);
    getContentPane().add(_listPanel);
    c.weighty = 0;
    c.weightx = 0;
    c.gridheight = 1;

    // 11
    c.gridx = 1;
    c.gridy = 2;
    c.gridwidth = 3;
    gridbag.setConstraints(selectLabel, c);
    getContentPane().add(selectLabel);
    c.gridwidth = 1;

    // 12
    c.gridx = 4;
    c.gridy = 2;
    c.gridheight = 3;
    gridbag.setConstraints(removeButton, c);
    getContentPane().add(removeButton);
    c.gridheight = 1;

    // 13
    c.gridx = 1;
    c.gridy = 3;
    gridbag.setConstraints(typeLabel2, c);
    getContentPane().add(typeLabel2);

    // 14
    c.gridx = 2;
    c.gridy = 3;
    gridbag.setConstraints(adjustLabel2,c);
    getContentPane().add(adjustLabel2);

    // 15
    c.gridx = 3;
    c.gridy = 3;
    gridbag.setConstraints(limitLabel2, c);
    getContentPane().add(limitLabel2);

    // 16
    c.gridx = 1;
    c.gridy = 4;
    gridbag.setConstraints(typeField2, c);
    getContentPane().add(typeField2);

    // 17
    c.gridx = 2;
    c.gridy = 4;
    gridbag.setConstraints(adjustField2, c);
    getContentPane().add(adjustField2);

    // 18
    c.gridx = 3;
    c.gridy = 4;
    gridbag.setConstraints(limitField2, c);
    getContentPane().add(limitField2);

    // 19
    c.gridx = 1;
    c.gridy = 5;
    c.weighty = 1;
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridbag.setConstraints(pathPanel, c);
    getContentPane().add(pathPanel);
    c.gridwidth = 1;
    c.weighty = 0;

    // 20
    c.gridx = 4;
    c.gridy = 5;
    c.weighty = 1;
    gridbag.setConstraints(pathButton, c);
    getContentPane().add(pathButton);
    c.weighty = 0;

    pack();
    setBounds(x,y,w,h);
    
  }

  void scSelect(final int clicks, final SemanticClass sc){
    _typeField.setSelectedItem(sc);
  }
  
  void scUpdate(final int type, final SemanticClass sc){
    _typeField.removeAllItems();
    SemanticClass[] sca=(SemanticClass[])_port.getSemanticClasses().toArray();
    java.util.Arrays.sort(sca);
    for(int i=0; i<java.lang.reflect.Array.getLength(sca); i++)
      _typeField.addItem(sca[i]);
    _typeField.validate();
  }

  void rUpdate(int type, Relation r){
    _listPanel.refresh();
  }

  public String toString(){
    return (_name);
  }

}
