package sneps3.world.gui;

import sneps3.exception.*;
import sneps3.classes.*;
import sneps3.spine.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

class RelationList extends JScrollPane{

  /**
   * @serial
   */
  protected JList _list;
  /**
   * @serial
   */
  protected DefaultListModel _listModel;
  /**
   * @serial
   */
  protected TelePort _port;
  /**
   * @serial
   */
  protected JTextField _type, _adjust, _limit;
  /**
   * @serial
   */
  protected Toolkit _toolkit;
  /**
   * @serial
   */
  protected RelationFrame _parent;

  RelationList(RelationFrame parent, TelePort port, JTextField type,
      JTextField adjust, JTextField limit){
    super();
    _parent = parent;
    _port = port;
    _type = type;
    _adjust = adjust;
    _limit = limit;
    _toolkit = Toolkit.getDefaultToolkit();
    _list = new JList();
    _list.getSelectionModel().setSelectionMode(
      ListSelectionModel.SINGLE_SELECTION);
    _listModel = new DefaultListModel();
    _list.setModel(_listModel);
    getViewport().setView(_list);

    _list.addListSelectionListener(new ListSelectionListener(){
        public void valueChanged(ListSelectionEvent e){
          Relation current = (Relation)_list.getSelectedValue();
          if (current == null){
            _type.setText("");
            _adjust.setText("");
            _limit.setText("");
            return;
          }
          _type.setText(current.getType().toString());
          switch (current.getAdjust()){
          case -1: _adjust.setText("Reduce");
            break;
          case 0: _adjust.setText("None");
            break;
          case 1: _adjust.setText("Expand");
            break;
          default: _adjust.setText("");
            break;
          }
          if (current.getAdjust()==0)
            _limit.setText("");
          else
            _limit.setText(Integer.toString(current.getLimit()));
        }
      });

    refresh();

  }

  void refresh(){
    _listModel.clear();

    Relation [] ra = (Relation [])_port.getRelations().toArray();
    java.util.Arrays.sort(ra);

    for (int i=0; i<java.lang.reflect.Array.getLength(ra); i++)
      _listModel.addElement(ra[i]);
    if (_list.getSelectedValue()==null){
      _type.setText("");
      _adjust.setText("");
      _limit.setText("");
    }
    _list.validate();
  }

  void removeSelectedRelation(){
    Relation selected = (Relation)_list.getSelectedValue();
    if (selected==null){
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, "Select a relation to remove.",
          "Error", JOptionPane.WARNING_MESSAGE);
      return;
    }
    try{
      _port.undefineRelation(selected.getName());
    } catch (SnepsException e) {
      _toolkit.beep();
      JOptionPane.showMessageDialog(_parent, e, "Error",
          JOptionPane.WARNING_MESSAGE);
      return;
    }
    _parent._mainFrame.rUpdate(-1,selected);
  }

}
