package sneps3.world.gui;

import sneps3.classes.*;
import sneps3.spine.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.tree.*;

/**
 */
class SemanticClassFrame extends JInternalFrame{

  protected static final String _name = "Semantic Classes";
  /**
   * @serial
   */
  protected final SemanticClassTree _treePanel;
  /**
   * @serial
   */
  protected GUI _mainFrame;
  
  public SemanticClassFrame(GUI mainFrame, TelePort port,
      int x, int y, int w, int h){
    super(_name, true, false, true, false);
    _treePanel = new SemanticClassTree(this,port);
    _mainFrame = mainFrame;
    
    JButton addButton = new JButton("Add");
    addButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          _treePanel.addObject();
        }
      });

    JButton removeButton = new JButton("Remove");
    removeButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e) {
          _treePanel.removeCurrentNode();
        }
      });

    JButton colorButton = new JButton("Set Color");
    colorButton.addActionListener(new ActionListener(){
        public void actionPerformed(ActionEvent e) {
          _treePanel.setNodeColor();
        }
      });

    //Lay everything out.
    getContentPane().setLayout(new BorderLayout());
    _treePanel.setPreferredSize(new Dimension(200, 250));
    getContentPane().add(_treePanel, BorderLayout.CENTER);

    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(0,1));
    panel.add(addButton);
    panel.add(removeButton);
    panel.add(colorButton);
    getContentPane().add(panel, BorderLayout.EAST);

    pack();

    setBounds(x,y,w,h);
  } 

  void scUpdate(int type, SemanticClass sc){
    _treePanel.scUpdate(type, sc);
  }

  void scSelect(SemanticClass sc){
    // might feel like doing this some day
  }
  
  public String toString(){
    return (_name);
  }

}
