package sneps3.world.gui;

import sneps3.classes.*;

import java.awt.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.awt.geom.*;
import java.awt.image.BufferedImage;

class SemanticClassRenderer extends DefaultTreeCellRenderer {

  protected static final int _SIZE = 25;
  protected static final int _WIDTH = 3;
  protected static final int _SIZE2 = _SIZE-_WIDTH-1;
  protected static Icon blankClass;

  public SemanticClassRenderer() {
    super();
    BufferedImage myImage = new BufferedImage(_SIZE,_SIZE,
        BufferedImage.TYPE_INT_RGB);

    Graphics2D myGraphics = myImage.createGraphics();
    myGraphics.setPaint(java.awt.Color.white);
    myGraphics.fill(new Rectangle2D.Double(0,0,_SIZE,_SIZE));
    myGraphics.setPaint(java.awt.Color.black);
    myGraphics.setStroke(new BasicStroke(_WIDTH));
    myGraphics.draw(new Ellipse2D.Double(_WIDTH-1,_WIDTH-1,_SIZE2,_SIZE2));    
    blankClass = new ImageIcon(myImage);
  }

  public Component getTreeCellRendererComponent(JTree tree, Object value,
      boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
    super.getTreeCellRendererComponent(tree,value,sel,expanded,leaf,row,
        hasFocus);

    BufferedImage myImage = new BufferedImage(_SIZE,_SIZE,
        BufferedImage.TYPE_INT_RGB);

    Graphics2D myGraphics = myImage.createGraphics();
    myGraphics.setPaint(java.awt.Color.white);
    myGraphics.fill(new Rectangle2D.Double(0,0,_SIZE,_SIZE));
    try{
      myGraphics.setPaint(((SemanticClass)
          (((DefaultMutableTreeNode)value).getUserObject())).getColor());
    }
    catch (ClassCastException e){
      myGraphics.setPaint(java.awt.Color.white);
    }
    Shape circle = new Ellipse2D.Double(_WIDTH-1,_WIDTH-1,_SIZE2,_SIZE2);
    myGraphics.fill(circle);
    myGraphics.setPaint(java.awt.Color.black);
    myGraphics.setStroke(new BasicStroke(_WIDTH));
    myGraphics.draw(circle);
    
    ImageIcon myIcon = new ImageIcon(myImage);
    setIcon(myIcon);
    return (this);
  }

  public Icon getLeafIcon(){
    return (blankClass);
  }

}
