function ess = ESS(lik)

if size(lik, 1) ~= 1
    lik = lik';
end

var_t = std(lik, 1)^2;
T = length(lik);

sumrho = 0;
for t = 1:T
    tmp = lik(t+1:T) - lik(1:T - t);
    v = tmp * tmp' / (T - t);
    rho = 1 - v / var_t / 2;
    if rho < 0
        break;
    end
    sumrho = sumrho + rho;
end

ess = T / (1 + 2 * sumrho);

% ess = length(lik) / (1 + var(lik) / mean(lik)^2);