function get_ave_ess(mcmc_samples)

n = length(mcmc_samples);
mm = zeros(1, n);
med = zeros(1, n);
minn = zeros(1, n);
for i = 1:n
	mcmc_samples_ = mcmc_samples{i};
	save -ascii _tmp mcmc_samples_;
	[jnk1,jnk2] = system('R CMD BATCH eff_smp.R');
	load my_tmp_R;
	mm(i) = mean(my_tmp_R');
	med(i) = median(my_tmp_R');
	minn(i) = min(my_tmp_R');
end
fprintf('Full stats:\n');
fprintf('mean = %f, med = %f, min = %f\n', mean(mm), mean(med), mean(minn));
fprintf('mean_std = %f, med_std = %f, min_std = %f\n', std(mm), std(med), std(minn));

m = size(mcmc_samples{1}, 2);
for i = 1:n
	mcmc_samples_ = mcmc_samples{i}(:, 2:m);
	save -ascii _tmp mcmc_samples_;
	[jnk1,jnk2] = system('R CMD BATCH eff_smp.R');
	load my_tmp_R;
	mm(i) = mean(my_tmp_R');
	med(i) = median(my_tmp_R');
	minn(i) = min(my_tmp_R');
end
fprintf('Excluding the first stats:\n');
fprintf('mean = %f, med = %f, min = %f\n', mean(mm), mean(med), mean(minn));
fprintf('mean_std = %f, med_std = %f, min_std = %f\n', std(mm), std(med), std(minn));
