function print_top_words(filename, voc, sample, topword)

phi = sample.mu';
fid = fopen(filename, 'w');
fprintf(fid, 'topics for the %s model:\n', sample.model);
fprintf(fid, '#based (top) NGGs: %d\n', length(sample.n));
fprintf(fid, '#derived (bottom) NGGs: %d\n', size(sample.q, 1));
fprintf(fid, '#topics in total: %d\n', length(sample.sum_mu));
fprintf(fid, '#words in each based NGG:\n');
for i = 1:length(sample.n)
    fprintf(fid, '%d:%d;\t', i, sample.n(i));
end
fprintf(fid, '\n\n');

for ns = 1:length(sample.n)
    fprintf(fid, '///////////////// topics from the %d-th based NGG ///////////////////\n', ns);
    n = 1;
    for i = 1:size(phi, 2)
        if sample.Kid(i) == ns - 1
            fprintf(fid, '------------Top words for topic %d (%d words in total)...-----------\n', n, sample.sum_mu(i));
            [a,IX] = sort(phi(:, i), 'descend');
            for j = 1:topword
                %fprintf(fid, '%s(%f) ', voc{IX(j)}, a(j));
                fprintf(fid, '%s ', voc{IX(j)});
            end
            fprintf(fid, '\n');
            n = n + 1;
        end
    end
    fprintf(fid, '///////////////// end ///////////////////\n\n');
end
fclose(fid);

return
