%%%%%% C implementation for z, t %%%%%%%%%%%%%

function [samples, lik_tr, lik_te, elapse, elapse_tot] = sampler_DHNGG_ave(data, G_id, M, q, burnin, every, ...
    numbofits, initK, v, h, dolik, a, tag_tr, output, log_file, model, measure)

elapse = 1;

mu0 = h;
[nG, nS] = size(q);
nDP = length(data);

if length(M) ~= nS
	M = M(1) * ones(1, nS);
end

nw = zeros(1, nDP);
nw_all = zeros(1, nDP);
for i = 1:nDP
	if tag_tr(i) == 1
    	nw(i) = length(data{i});
    	nw_all(i) = length(data{i});
	else
		nw_all(i) = length(data{i});
		nw(i) = ceil(nw_all(i) / 2);
	end
end

if length(initK) ~= nS
    if nS < 100
        initK = initK(1) * ones(1, nS);
    else
        initK = initK(1) * ones(1, nS);
        initK(2:nS) = 1;
    end
end

% Set up for calculating predictive or not
s = cell(1, nDP);
cumK = zeros(1, nS + 1);
cumK(2:nS+1) = cumsum(initK);
K_id = zeros(1, sum(initK));
for i = 1:nS
	K_id(cumK(i)+1:cumK(i+1)) = i;
end

if isempty(find(q == 0))
    for i = 1:nDP
        s{i} = ceil(rand(1, nw(i)) * sum(initK));
    end
else
    for i = 1:nDP
        kk = initK .* double(q(G_id(i), :) > 0);
        f = 1;
        k1 = [];
        for j = 1:length(kk)
            if kk(j) > 0
                k1(f:f+kk(j)-1) = cumK(j)+1:cumK(j+1);
                f = f + kk(j);
            end
        end
        s{i} = k1(ceil(rand(1, nw(i)) * (f - 1)));
        assert(min(s{i}) > 0 && max(s{i}) <= sum(initK));
        for j = 1:length(s{i})
            assert(q(G_id(i), K_id(s{i}(j))) > 0);
        end
    end
end
kstar = initK;

% Set jump sizes and parameters of components
mu = zeros(sum(kstar) + 1, v);
for j = 1:nDP
    for i = 1:nw(j)
        mu(s{j}(i), data{j}(i)) = mu(s{j}(i), data{j}(i)) + 1;
    end
end
sum_mu = sum(mu, 2)';

nd_tk = zeros(size(mu, 1), nDP);
nd_nk = zeros(size(mu, 1), nDP);
nd_t = zeros(1, nDP);
for j = 1:nDP
	for i = 1:nw(j)
		nd_nk(s{j}(i), j) = nd_nk(s{j}(i), j) + 1;
		if nd_tk(s{j}(i), j) == 0
			nd_tk(s{j}(i), j) = 1;
		end
	end
	for k = 1:size(mu, 1)
		nd_t(j) = nd_t(j) + nd_tk(k, j);
	end
end

n_t = zeros(1, nG);
K_c = zeros(1, nG + 1);
nj = zeros(1, size(mu, 1));
n = zeros(1, nS);
n_ts = zeros(nG, nS);
nj_t = zeros(nG, size(mu, 1));
K_c(nG + 1) = length(find(sum_mu > 0));
for g = 1:nG
	idx = find(G_id == g);
	for k = 1:size(mu, 1)
		tmp = length(find(nd_tk(k, idx) > 0));
		if tmp > 0
			K_c(g) = K_c(g) + 1;
		end
    end
    for i = 1:length(idx)
        for k = 1:size(mu, 1)
            nj_t(g, k) = nj_t(g, k) + nd_tk(k, idx(i));
        end
    end
    for k = 1:size(mu, 1)
        n_t(g) = n_t(g) + nj_t(g, k);
    end
end
for k = 1:size(mu, 1)
    nj(k) = sum(nd_tk(k, :));
end
for k = 1:size(mu, 1)-1
    n(K_id(k)) = n(K_id(k)) + nj(k);
end
for i = 1:nDP
    for k = 1:size(mu, 1)-1
        n_ts(G_id(i), K_id(k)) = n_ts(G_id(i), K_id(k)) + nd_tk(k, i);
    end
end

K_ct = zeros(1, nS);
for k = 1:size(mu, 1)-1
	if nj(k) > 0
		K_ct(K_id(k)) = K_ct(K_id(k)) + 1;
	end
end

ng = zeros(1, nG);
for g = 1:nG
	ng(g) = length(find(G_id == g));
end

K_id = K_id - 1;
K_id = [K_id -1];
G_id = G_id - 1;

tic

if strcmp(model, 'HMNGG') == 1
    [samples, lik_tr, lik_te] = sample_zt_HMNGG(mu, sum_mu, s, M, q, n, n_t, ...
        n_ts, nj, nj_t, K_c, K_ct, K_id, G_id, ng, nd_nk, nd_tk, nw, mu0, ...
        burnin, numbofits, every, dolik, data, a, gamma(1 - a), nw_all, ...
        tag_tr, output, log_file);
% %%%%%%%%% spatial structure %%%%%%%%%%%%%%%%%%
%     [samples, lik_tr, lik_te] = sample_zt_HMNGG_v2(mu, sum_mu, s, M, q, n, n_t, ...
%         n_ts, nj, nj_t, K_c, K_ct, K_id, G_id, ng, nd_nk, nd_tk, nw, mu0, ...
%         burnin, numbofits, every, dolik, data, a, gamma(1 - a), nw_all, ...
%         tag_tr, output, log_file, measure);
elseif strcmp(model, 'SNGGh') == 1
	%%% SNGGh: weights controlled by q, is a MNGG with fixed weights q, not really a SNGG
%     [samples, lik_tr, lik_te] = sample_zt_SNGGh(mu, sum_mu, s, M, q, n, n_t, ...
%         n_ts, nj, nj_t, K_c, K_ct, K_id, G_id, ng, nd_nk, nd_tk, nw, mu0, ...
%         burnin, numbofits, every, dolik, data, a, gamma(1 - a), nw_all, ...
%         tag_tr, output, log_file);

	%%% SNGGh: spatial NGG with weights qq for each region
    [samples, lik_tr, lik_te] = sample_zt_SNGGh_v2(mu, sum_mu, s, M, q, n, n_t, ...
        n_ts, nj, nj_t, K_c, K_ct, K_id, G_id, ng, nd_nk, nd_tk, nw, mu0, ...
        burnin, numbofits, every, dolik, data, a, gamma(1 - a), nw_all, ...
        tag_tr, output, log_file, measure);
elseif strcmp(model, 'SNGPh') == 1
    [samples, lik_tr, lik_te] = sample_zt_SNGPh(mu, sum_mu, s, M, q, n, n_t, ...
        n_ts, nj, nj_t, K_c, K_ct, K_id, G_id, ng, nd_nk, nd_tk, nw, mu0, ...
        burnin, numbofits, every, dolik, data, nw_all, ...
        tag_tr, output, log_file);
elseif strcmp(model, 'HTNGG_marg2') == 1
    [samples, lik_tr, lik_te, elapse] = sample_zt_HTNGG_marg2(mu, sum_mu, s, M, q, n, n_t, ...
        n_ts, nj, nj_t, K_c, K_ct, K_id, G_id, ng, nd_nk, nd_tk, nw, mu0, ...
        burnin, numbofits, every, dolik, data, a, gamma(1 - a), nw_all, ...
        tag_tr, output, log_file);
end

elapse_tot = toc;

for i = 1:length(samples)
	samples(i).gamma = h;
	samples(i).V = v;
	samples(i).model = model;
end
