/*
 * gibbs.c
 *
 */
#include "gibbs.h"
#include <gsl/gsl_randist.h>
#include <scythestat/stat.h>
#include <scythestat/smath.h>

/*
 * uniformly initialize the topic assignment of each word
 */

void init_state_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c, int est_inf, int init_z, int initeta)
{
	int j, l, k, q, w;
	time_t seed;
	gsl_rng* r;

	printf(">>>>>> Begin initialize the states ......\n");

	for(j = 0; j < model->L; j++){
		model->eta_z[j] = (double*)calloc(c->ndocs, sizeof(double));
	}
	for(j = 0; j < model->C; j++){
		model->eta_z_aux[j] = (double*)calloc(c->ndocs, sizeof(double));
	}

	for(j = 0; j < c->ndocs; ++j){
		cts->N[j] = 0;
		for(k = 0; k < model->K; ++k){
			(*cts->n)(k, j) = 0;
		}
		(*cts->n)(model->K, j) = c->docs[j].total;
		for(k = 0; k < model->K; ++k){
			cts->M[k] = 0;
			for(w = 0; w < model->v; ++w){
				cts->m[k][w] = 0;
			}
		}
	}
	r = gsl_rng_alloc(gsl_rng_taus);
	time(&seed);
//	seed = 1115574245;
	gsl_rng_set(r, (long)seed);

	if(initeta){
		for(k = 0; k < model->K + 1; k++){
			for(int t = 0; t < model->L; t++){
				model->eta[t][k] = gsl_ran_gaussian(r, model->nu);
			}
			for(int t = 0; t < model->C; t++){
				model->eta_aux[t][k] = gsl_ran_gaussian(r, model->nu);
			}
		}
	}

	for (j = c->ndocs - 1; j >= 0; j--){
		if(j > c->ndocs - 100 || j < 100){
			cts->yd[j] = c->docs[j].yd;
		}else{
			cts->yd[j] = (int)floor(gsl_rng_uniform(r) * model->L);
		}

		for (l = 0; l < c->docs[j].total; l++){
			if(init_z){
				q = ass->topic_ass[j][l];
			}else{
				q = (int)floor(gsl_rng_uniform(r) * model->K);
				ass->topic_ass[j][l] = q;
			}
			(*cts->n)(q, j) += 1;
			cts->N[j] += 1;
			if(est_inf == 0){
				cts->m[q][c->docs[j].words[l]] += 1;
			}
		}
	}
	for(k = 0; k < model->K; k++){
		cts->M[k] = 0;
		for(j = 0; j < model->v; j++){
			cts->M[k] += cts->m[k][j];
		}
	}

	for(int i = 0; i < c->ndocs; i++){
		cts->lambda[i] = 1;
	}

	if(initeta){
		/*for(k = 0; k < model->K + 1; k++){
			model->eta_sum[k] = 0;
			for(l = 0; l < model->L; l++){
				model->eta_sum[k] += model->eta[l][k];
			}
		}*/
		for(l = 0; l < model->L; l++){
			for(int d = 0; d < c->ndocs; d++){
				model->eta_z[l][d] = 0;
				for(k = 0; k < model->K + 1; k++){
					model->eta_z[l][d] += model->eta[l][k] * (*cts->n)(k, d) / cts->N[d];
				}
			}
		}
		for(l = 0; l < model->C; l++){
			for(int d = 0; d < c->ndocs; d++){
				model->eta_z_aux[l][d] = 0;
				for(k = 0; k < model->K  +1; k++){
					model->eta_z_aux[l][d] += model->eta_aux[l][k] * (*cts->n)(k, d) / cts->N[d];
				}
			}
		}
	}

	cts->Cy = (int*)calloc(model->maxL, sizeof(int));
	for(int d = 0; d < c->ndocs; d++){
		cts->Cy[cts->yd[d]]++;
	}

	gsl_rng_free(r);
	printf("The seed for init_gibbs: %ld\n", (long)seed);
	printf("<<<<<< End initialization \n");
}
