/*
 * gibbs.h
 *
 */

#ifndef GIBBS_H_
#define GIBBS_H_

#include <time.h>
#include <math.h>
#include <assert.h>

#include <gsl/gsl_rng.h>
#include <gsl/gsl_sf.h>
#include <gsl/gsl_math.h>
#include <gsl/gsl_vector.h>

#include "model.h"
#include "corpus.h"
#include "NBMM.h"
#include "util.h"

void init_state_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c, int est_inf, int init_z, int initeta);

void stm_e_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c, int doy);

void held_out_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c, Cts *cts_tr);

double heldout_predict(Model* model, Cts* cts, Assignment* ass, Corpus* c, int nSamples, int burnin);

#endif /* GIBBS_H_ */
