/*
 * inf_Gibbs.c
 *
 */
#include <iostream>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_permutation.h>
#include "gibbs.h"
#include "params.h"


extern dpyp_params PARAMS;
extern double* vec;
extern gsl_rng* glob_r;

static int held_out_sample_topic(int d, int l, int w, Assignment* ass, Cts* cts, Model* model, Cts *cts_tr)
{
	int old_topic, new_topic;
	int k, KK;
	double sum_v = model->v * model->gamma;

	KK = model->K;
	old_topic = ass->topic_ass[d][l];
	(*cts->n)(old_topic, d) -= 1;

	for(k = 0; k < KK; ++k){
		vec[k] = (model->alpha + (*cts->n)(k, d)) * ((cts_tr->m[k][w] + model->gamma) / (cts_tr->M[k] + sum_v));
	}

	sum_v = 0;
	for(k = 0; k < KK; ++k)
		sum_v += vec[k];
	for(k = 0; k < KK; ++k)
		vec[k] = vec[k] / sum_v;
	new_topic = next_discrete_normalised(vec, KK);

	ass->topic_ass[d][l] = new_topic;
	(*cts->n)(new_topic, d) += 1;

	return new_topic;
}


void held_out_gibbs(Model* model, Cts* cts, Assignment* ass, Corpus* c, Cts *cts_tr)
{
	int d, l, w;
	gsl_permutation * p;

	for(d = 0; d < c->ndocs; ++d){
		p = gsl_permutation_alloc (c->docs[d].total);
		gsl_permutation_init (p);
		gsl_ran_shuffle (glob_r, p->data, c->docs[d].total, sizeof(size_t));
		for(l = 0; l < c->docs[d].total; ++l){
			w = gsl_permutation_get(p, l);
			held_out_sample_topic(d, w, c->docs[d].words[w], ass, cts, model, cts_tr);
		}
		gsl_permutation_free(p);
	}
}
