/*
 * main.cpp
 *
 *  Created on: Aug 23, 2013
 *      Author: cchen
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <gsl/gsl_math.h>
#include <libgen.h>

#include "util.h"

#include <scythestat/matrix.h>
#include <scythestat/rng.h>
#include <scythestat/error.h>
#include <scythestat/algorithm.h>
#include <scythestat/ide.h>
#include "util.h"

#include "NBMM.h"
#include "corpus.h"
#include "params.h"

extern dpyp_params PARAMS;
extern gsl_rng* glob_r;

struct Args
{
	int do_ei;
	char* run_num;
	int heldout;
	int K;
	int z;
	int seed;

	char* z_root;
	char* setting;
	char* data_name;
	char* v_data;
	char* mod_file;
	char* o_file;
}Args;

/*
 * Command line processing
 */
void initialize_args()
{
	Args.do_ei = 0;
	Args.run_num = NULL; //1;
	Args.heldout = 1;
	Args.K = 0;
	Args.z = 0;
	Args.seed = -1;

	Args.setting = NULL;
	Args.data_name = NULL;
	Args.v_data = NULL;
	Args.mod_file = NULL;
	Args.o_file = NULL;
}

static const char* optString = "eipus:n:v:V:S:t:T:I:o:m:P:a:b:B:A:G:q:z:f:k:h?";

int main(int argc, char* argv[])
{
	/*//testing ellipse slice sampler
	gsl_rng_env_setup();                          // Read variable environnement
	const gsl_rng_type* type = gsl_rng_default;   // Default algorithm 'twister'
	glob_r = gsl_rng_alloc (type);
	gsl_vector *mean = gsl_vector_calloc(1);
	gsl_matrix *var = gsl_matrix_calloc(1, 1);
	mset(var, 0, 0, 2);
	gsl_vector *f = gsl_vector_calloc(1);
	vset(f, 0, 1);
	for(int i = 0; i < 100; i++){
		Ellip_slice(f, mean, var);
		std::cout << vget(f, 0) << std::endl;
	}
	gsl_vector_free(mean);
	gsl_vector_free(f);
	gsl_matrix_free(var);
	gsl_rng_free(glob_r);
	exit(0);*/

	/*gsl_rng_env_setup();                          // Read variable environnement
	const gsl_rng_type* type = gsl_rng_default;   // Default algorithm 'twister'
	glob_r = gsl_rng_alloc (type);
	scythe::Matrix<> mu(1, 2, false);
	mu = 0, 0;
	scythe::Matrix<> sigma(2, 2, false);
	sigma = 1, -0.2, -0.2, 2;
	scythe::Matrix<> A(2, 3, false);
	A = 1, -1, -1, 2, -1, 0; //-1, 1, 1, -2; //-1, 1, 2, -3, 0, 1;
	scythe::Matrix<> b(1, 3, false);
	b = 1, -2, 1; //-1, 2; //-2, 6, 0;

	scythe::Matrix<> A1 = scythe::t(A);
	scythe::Matrix<> b1 = scythe::t(b);
	scythe::Matrix<> mu1 = scythe::t(mu);
	scythe::Matrix<> samples(2, 1, false);
	samples = -1.0, 0;//1.5, 0; //-1, -1.8;
	for(int i = 0; i < 100; i++){
		rtnorm_mul(glob_r, A1, b1, mu1, sigma, 1, samples, 10);
		std::cout << samples(0) << " " << samples(1) << ";" << std::endl;
	}

	//scythe::Matrix<> samples(100, 2, false);
	//rmvnrnd(glob_r, mu, sigma, 100, A, b, samples, 100 - samples.rows());
	//std::cout << std::endl << samples << std::endl;

	//for(int i = 0; i < 100; i++){
	//	std::cout << rtgamma_rate(9, 2, 5) << std::endl;
	//}
	gsl_rng_free(glob_r);
	exit(0);*/

	int opt = 0;
	initialize_args();
	opt = getopt(argc, argv, optString);
	while(opt != -1)
	{
		switch(opt){
			case 'e': // for running estimation
				Args.do_ei = 1;
				break;
			case 'i':
				Args.do_ei = -1;
				break;
			case 'p':
				Args.do_ei = 0;
				break;
			case 'u': // using held-out/left-to-right likelihood calculation
				Args.heldout = 0;
				break;
			case 'n':
				Args.run_num = optarg; //atoi(optarg);
				break;
			////////////////////////////////////////////
			case 'v': // for vocabulary file
				Args.v_data = optarg;
				break;
			case 't': // for training or testing data
				Args.data_name = optarg;
				break;
			case 's': // for training/testing setting file
				Args.setting = optarg;
				break;
			case 'S':
				Args.seed = atoi(optarg);
				break;
			//////////////////////////////////////////
			case 'o':
				Args.o_file = optarg;
				break;
			case 'm':
				Args.mod_file = optarg;
				break;
			case 'z':
				Args.z = atoi(optarg);
				break;
			case 'f':
				Args.z_root = optarg;
				break;
			case 'h': // for command help
				printf("help!!!\n");
				break;
			default:
				break;
		}
		opt = getopt(argc, argv, optString);
	}

	vocabulary* v;
	Corpus* c_tr, *c_te;
	char str[BUFSIZ];
	char root[BUFSIZ];

	printf("COMMAND-LINE: %s ", basename(argv[0]));
	int loop;
	for (loop=1; loop < argc; loop++){
		printf("%s ", argv[loop]);
	}
	printf("\n\n");

	if(Args.do_ei == 1){
		printf("Sampling the NBMM-LDA model ...\n");
		v = read_vocabulary(Args.v_data);
		sprintf(root, "%s", Args.o_file);
		mkdir(root, S_IRUSR | S_IWUSR | S_IXUSR);
		read_params(Args.setting, 0); //1: includes testing, 0: only training
		sprintf(root, "%s/r_%s", root, Args.run_num);
		mkdir(root, S_IRUSR | S_IWUSR | S_IXUSR);

		sprintf(str, "%s/README", root);
		write_params(str);
		print_params();
		printf("Reading training corpus ...\n");

		c_tr = (Corpus*)malloc(sizeof(Corpus));
		if(PARAMS.test_data){
			c_te = (Corpus*)malloc(sizeof(Corpus));
		}else{
			c_te = NULL;
		}

		read_data(Args.data_name, PARAMS.train_data, PARAMS.test_data, c_tr, c_te, PARAMS.tr_percent);
		//save_local_vocabulary(c_tr, v, root);

		estimate(c_tr, c_te, v, root, Args.data_name, Args.z, Args.z_root, 0);

		printf("End sampling the model ...\n");
		printf("Results saved at %s\n", root);
	}else if(Args.do_ei == 0){//prediction
		printf("Predicting ...\n");
		v = NULL;
		sprintf(root, "%s", Args.o_file);
		sprintf(root, "%s/r_%s", root, Args.run_num);
		read_params(Args.setting, 0);

		printf("Reading training corpus ...\n");

		c_tr = (Corpus*)malloc(sizeof(Corpus));
		c_te = NULL;

		read_data(Args.data_name, PARAMS.train_data, NULL, c_tr, c_te, 1);

		estimate(c_tr, c_te, v, root, Args.data_name, Args.z, Args.z_root, 1);

		printf("End predicting ...\n");
	}
	free_params(&PARAMS);
	return (0);
}
