/*
 * model.h
 *
 */

#ifndef MODEL_H_
#define MODEL_H_

#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <scythestat/matrix.h>

#include "corpus.h"

using namespace scythe;

typedef struct Model {
	int v; // total vocabulary length
	int K; //number of topics for each class data
	double gamma;
	double alpha;
	int L;
	int maxL;

	//gsl_matrix* phi;

	double **eta;
	//double *eta_sum; // K * 1, no need
	double **eta_z; //eta * Z, L * D
	double **eta_aux;
	double **eta_z_aux;

	int C; //#auxiliary components
	double c;
	double ell;
	double nu; //prior for eta
	double omega;
} Model;

/*
 * count tables
 */
typedef struct Cts {
	Matrix<> *n; //(K+1) * D
	double *lambda;
	int* N; // d_i
	int** m; // K * W
	int* M; //K
	int *yd; //
	int *Cy;
} Cts;

/*
 * topic assignments
 */
typedef struct assignment {
	int** topic_ass; //D * L_{D_i}
} Assignment;

/*
 * estimator
 */
typedef struct Estimator{
	gsl_matrix* mu;
	gsl_matrix* phi;
} Estimator;
/*
 * functions
 */
Model* new_model(int v, int K, double c, int C, double ell, double L, double nu);
Cts* new_cts(int K, int v, Corpus* c);
Assignment* new_assignment(Corpus* c);

Model* random_init(int K, int v, double c, int C, double ell,
		double L, double nu, double alpha, double gamma);
Model* read_model(char* file);
void save_model(Model* model, Cts *cts, int D, char* file);

Assignment* read_topic_assignmnet(Corpus* c, char* file);
void save_topic_assignmnet(Corpus* c, Assignment* ass, char* file);
void print_top_words(int num_words, int begin_k, int end_k, int** M, Cts* cts, vocabulary* v,
		char* file);

void free_assignment(Assignment*, Corpus* c);
void free_cts(Cts*, Corpus* c, int K);
void free_model(Model*);
void free_all(Corpus*, Model*, Cts*, Assignment*, vocabulary*);


#endif /* MODEL_H_ */
