/*
 * CobHelp.java
 *
 * Created on Feb 20, 2002, 5:31 PM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.lang.*;
import javax.swing.text.*;

class CobHelp
{
    public static final int TOOL = 2334 ;
    public static final int AUTHOR = 8745 ;
    public static final int DRAW = 8275 ;
    public static final int CONSTRAINTS = 82 ;
    public static final int RUN = 422 ;
    public static final int DEBUG = 234 ;
    public static final int SAVE = 641 ;
    public static final int LOAD = 145 ;
    public static final int TROUBLE = 932;    
    public static void showHelp(int type)
    {
	 JOptionPane.showMessageDialog(null,getText(type),"Help", JOptionPane.PLAIN_MESSAGE);
    }
    
    private static String getText(int type)
    {
        String text = "";
	switch(type){
	 case TOOL:
	     text += "The Circuitry v2.2 has been developed\nto demonstrate the capability of\nConstraint Object Language (COB). The\nCOB code is generated based on circuit\ndrawn and inputs provided by the user\non the tool. The COB code is then\ntranslated to CLP(R) which then is\nexecuted to solve the constraints in\nthe system.";
	     break;
	 case AUTHOR:
	     text += "CREDITS\n\nConcept:\n        Dr. Bharat Jayaraman\n        (bharat@cse.buffalo.edu)\n\nDevelopment:\n    Abhilash Dev\n        (adev@cse.buffalo.edu)\n\nGraphics:\n Narayan Menon\n        (nmenon@cse.buffalo.edu)\n\nCOB Translator:\n    Pallavi Tambay\n      (tambay@cse.buffalo.edu)\n\nComplex number Approach:\n    Prakash Rajamani\n      (praks@cse.buffalo.edu)  and\n    Palaniappan Sathappa\n      (ps38@cse.buffalo.edu)";
	     break;
	 case DRAW:
	     text += "Drawing Circuit:\n\nThe Circuit can be drawn on the\neditor window 'Circuit'.\nUsing the Resistor, Battery and\nWire buttons on the left side the\ncorresponding electrical\ncomponents can be placed on the\ncanvas. These components can be\njoined at their nodes to form a\ncircuit by dragging and pulling\nthe components from their center\nand from their edges.";
	     break;
	 case CONSTRAINTS:
	     text += "Putting Constraints:\n\nThe input constraints on any\ncomponent can be provided at the\ntime when its being placed on to\nthe canvas. These can be fed into\nthe input window that pops up\nwhen the new component is placed.\n\nThe constraints can also be\nmodified by right-clicking on the\ncenter of the component for which\nconstraints have to be modified.\n\nThe Instance constraint refers to\nthe constraint on a particular\nelectrical component on the\ncircuit\n\nThe Type constraint refers to the\nconstraints on the Component type\nand will apply to all the\ninstances of that type. \n\ne.g. N1.V - N2.V = I * R is the\nconstraint on all the Resistor\ncomponents. Changing this will\naffect all the resistors on the\ncircuit";
	     break;
	 case RUN:
	     text = "Running Code:\n\n1. In order to run the code after\n   circuit has been drawn, go to\n   Tools on the menu and click on\n   'compile'. The circuit is seen\n   blinking. After this, again go\n   to Tools Menu and click on\n   'run'. This should run the code\n   and switch to the Results\n   Window.\n\n   If an error message is seen,\n   refer to help on trouble-\n   shooting.\n\n2. The overall results are listed\n   under the circuit. In order to\n   view the results for any single\n   electrical component, click on\n   that component and its results\n   can be seen.";
	     break;
	 case DEBUG:
	     text += "Debugging:\n\nIn order to check the generated\nCOB Code and CLP(R) code, go to\n'Code' Window\n\nIn order to check the Prolog and\nCLP(R) outputs, go to 'Diagnose'\nwindow\n  \nIn order to view these windows\nalong with Circuit or Results\nwindows, go to 'view' menu  and\nclick on 'Eject'. This pops up\n'Code' or 'Diagnose' Window as a\nseparate window. You can now go\nto any window on the tool.";
	     break;
	 case SAVE:
	     text += "Saving:\n\nCircuit: Circuit can be saved by\nclicking 'Save' in 'File' menu.\nThe extension for the file is .ckt\nThe circuit can be saved only from\nthe editor window 'Circuit'\n\nCOB code can also be saved as .cob\nfile. This can be done by clicking \n'Save' under 'File' menu. This can\nbe done only from the 'Code'\nwindow.";
	     break;
	 case LOAD:
	     text += "Loading Circuit:\n\nPreviously stored circuit can be\nloaded by clicking 'Open' under\n'File' menu and by selecting the\nappropriate .ckt file.";
	     break;
	 case TROUBLE:
	     text += "Troubleshooting:\n\nMost of the errors that you can encounter have to \ndo with the paths specified in config file 'cob.cfg'.\nCheck this file for all the paths listed\n\nIf the application crashes and core dumps then update\nthe Java runtime environment on your computer or\ncheck the solaris patches( for Sun workstation).";
	     break;
	 default:
	}
	return text;
    }

}
