package cse605;


/**
 *
 * @author  adev
 * @version 
 */
import java.awt.*;
import javax.swing.*;
import java.util.*;
import java.lang.ref.*;

public class Wire extends ElecComponent {
    public final int NONE_SELECTED =0, ONE_SELECTED =1, TWO_SELECTED = 2, BOTH_SELECTED = 3;
    public int x1, y1, x2, y2;
    public static int count;
    private static LinkedList constraints ;
    /** Creates new Wire */
    public Wire(Node l_node, Node r_node) {
        if(count==0) initConstraint();
        count++;
        ID = "W"+count;
	Icount++;
	Iid = "I"+ Icount;
        x1 = (int)(l_node.x + Node.w/2);
        y1 = (int)(l_node.y + Node.h/2);
        x2 = (int)(r_node.x + Node.w/2);
        y2 = (int)(r_node.y + Node.h/2);
        this.l_node = l_node;
        this.r_node = r_node;
    }

    public static void setCount(int val)
    {
        count = val;
    }
    
    private static void initConstraint()
    {
        constraints = new LinkedList();
        constraints.add("N1.V = N2.V;");
    }

    public static LinkedList getConstraints()
    {
        if(constraints==null) initConstraint();
        return constraints;
    }
    
    public static void addConstraints(String cnstr)
    {
        constraints.add(cnstr);
    }

    public static void removeAllConstraints()
    {
        constraints.clear();
    }

    public String getType() {
        return "Wire";
    }

    public void adjustNodes()
    {
        if(l_node.x > r_node.x)//swap the nodes
        {
            Node temp = (Node)(new WeakReference(r_node)).get() ;
            r_node = l_node;
            l_node = temp;
        }
    }
    
    public void picked(Graphics g)
    {
        isPicked = true;
    	g.setColor(Color.green);
         Graphics2D g2 = (Graphics2D) g;
        
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);

        g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                            RenderingHints.VALUE_RENDER_QUALITY);
	showVals(g);
        g2.setColor(new Color(255,0,255));
        g.drawLine((int)(l_node.x+ l_node.w/2), (int)(l_node.y + l_node.h/2), (int)(r_node.x+r_node.w/2), (int)(r_node.y + r_node.h/2));
 	showID(g);
   }

    public void draw(Graphics g)
    {
        if(prevPainted){
            prevPainted = false;
            return;
        }
        prevPainted = true;

        adjustCenter();
        adjustNodes();
        
        if(l_node.isSelected && r_node.isSelected )g.setColor(Color.red);
        else g.setColor(Color.black);

        g.drawLine((int)(l_node.x+ l_node.w/2), (int)(l_node.y + l_node.h/2), (int)(r_node.x+r_node.w/2), (int)(r_node.y + r_node.h/2));

    }

    public void basicDraw(Graphics g)
    {
	draw(g);
    }
    
}
