class node{
 attributes
   Real V;
   real [] Current;
 constraints
   sum I in Current: I = 0;
 constructors node(Curr, V1){
   Current = Curr;
   V = V1;
 }
}

class edge{
 attributes
  Real I,R;
  node N1,N2;
 constraints
  I * R = (N1.V - N2.V);
 constructors edge(Na, Nb, I1, R1){
  N1 = Na;
  N2 = Nb;
  I = I1;
  R = R1;
 }
}

class battery{
 attributes
  Real B;
  node N1, N2;
 constraints
  B = (N1.V - N2.V);
 constructors battery(Na,Nb,B1){
  N1 = Na;
  N2 = Nb;
  B = B1;
 }
}

class circuit{
 attributes
   node N1,N2,N4,N6,N7,N3,N8,N9,N10,N11;
   edge R1,R2,R3,R4,R5,R6,W6,W5,W2,W1,W3,W4;
   battery B1,B2;
   Real [] N1amps,N2amps,N4amps,N6amps,N7amps,N3amps,N8amps,N9amps,N10amps,N11amps;
   Real [] Answer;
 constraints
   Answer[1] = R1.I;
   Answer[2] = R2.I;
   Answer[3] = R3.I;
   Answer[4] = R4.I;
   Answer[5] = R5.I;
   Answer[6] = R6.I;
 constructors circuit(X){
   N1amps[1]=I1;
   N1amps[2]=I9;
   N1amps[3]=I7;

   N2amps[1]=(0-I1);
   N2amps[2]=I10;
   N2amps[3]=(0-I8);

   N4amps[1]=(0-I2);
   N4amps[2]=I3;

   N6amps[1]=I4;
   N6amps[2]=(0-I7);
   N6amps[3]=I8;

   N7amps[1]=(0-I4);
   N7amps[2]=(0-I3);
   N7amps[3]=(0-I11);

   N3amps[1]=I2;
   N3amps[2]=(0-I12);
   N3amps[3]=(0-I9);

   N8amps[1]=I5;
   N8amps[2]=I12;
   N8amps[3]=I13;

   N9amps[1]=(0-I5);
   N9amps[2]=I11;
   N9amps[3]=I14;

   N10amps[1]=I6;
   N10amps[2]=(0-I13);

   N11amps[1]=(0-I6);
   N11amps[2]=(0-I14);
   N11amps[3]=(0-I10);

   N1 = new node(N1amps,V0);
   N2 = new node(N2amps,V1);
   N4 = new node(N4amps,V2);
   N6 = new node(N6amps,V3);
   N7 = new node(N7amps,V4);
   N3 = new node(N3amps,V5);
   N8 = new node(N8amps,V6);
   N9 = new node(N9amps,V7);
   N10 = new node(N10amps,V8);
   N11 = new node(N11amps,V9);

   B1 = new battery(N6,N1,5);
   B2 = new battery(N2,N6,5);

   R1 = new edge(N2,N1,I1,5);
   R2 = new edge(N4,N3,I2,6);
   R3 = new edge(N7,N4,I3,7);
   R4 = new edge(N7,N6,I4,5);
   R5 = new edge(N9,N8,I5,5);
   R6 = new edge(N11,N10,I6,6);

   W6 = new edge(N3,N1,I9,0);
   W5 = new edge(N11,N2,I10,0);
   W2 = new edge(N7,N9,I11,0);
   W1 = new edge(N3,N8,I12,0);
   W3 = new edge(N10,N8,I13,0);
   W4 = new edge(N11,N9,I14,0);

   X = Answer;
 }
}

class answer {
 attributes
   real [] Answer;
 constructors answer(X) {
   X = new circuit(Answer);
 }
}
$
