/*
 * Beam.java
 *
 * Created on April 18, 2001, 12:20 AM
 */

package cse605;

/**
 *
 * @author  adev
 * @version 
 */
import java.awt.*;
import javax.swing.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.lang.ref.*;
import java.util.*;

public class Beam extends Bar
{


    public static final int STD_WIDTH = 70;
    public static final int STD_HEIGHT = 12;
    private static LinkedList constraints ;
    public static int count;
    public int x, y;


    // Creates new Resistor 
    public Beam(Object[] input, Node l_node, Node r_node) {
        if(count==0) initConstraint();
        count++;
        ID = "B"+count;
        x = (int)l_node.x + Node.w;
        y = (int)(l_node.y - Node.h/2);
        this.l_node = l_node;
        this.r_node = r_node;
        
        elasticity 	=	(String)input[0];
        sy 			= 	(String)input[1];
        length 		= 	(String)input[2];
        width 		= 	(String)input[3];
        height 		= 	(String)input[4];
        f_bn 		= 	(String)input[5];
        f_bk 		= 	(String)input[6];
        f_t 		= 	(String)input[7];
        sigma 		= 	(String)input[8];
        bar_i 		= 	(String)input[9];
        bar_f 		= 	(String)input[10];    	
    
    }

    public static void setCount(int val)
    {
        count = val;
    }

    private static void initConstraint()
    {
        constraints = new LinkedList();
        constraints.add("0 <= A; A<= 360");
    }

    public static void removeAllConstraints()
    {
      constraints.clear();
    }

    public static LinkedList getConstraints()
    {
        if(constraints==null) initConstraint();
        return constraints;
    }
    
    public static void addConstraints(String cnstr)
    {
        constraints.add(cnstr);
    }

    public String getType() {
        return "Beam";
    }

    public void adjustNodes()
    {
        if(l_node.x > r_node.x)//swap the nodes
        {
            Node temp = (Node)(new WeakReference(r_node)).get() ;
            r_node = l_node;
            l_node = temp;
        }
    }
    
    public void picked(Graphics g)
    {
    	isPicked = true;
	g.setColor(Color.green);
         Graphics2D g2 = (Graphics2D) g;
        
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);

        g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                            RenderingHints.VALUE_RENDER_QUALITY);
	showVals(g);
//        g2.setColor(new Color(68,141,31));
        g2.setColor(new Color(255,0,255));
 	
	int dist =
	(int)Math.pow((Math.pow((r_node.x-l_node.x),2)+Math.pow((r_node.y-l_node.y),2)),0.5) ;
        int fontSize =(int)(dist/4) ;
        if(fontSize>12) fontSize = 12;
        if(fontSize <6) fontSize = 8;
        int fontStyle ;
        if(fontSize<9) fontStyle = Font.BOLD ;
        else fontStyle = Font.PLAIN;
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = new Font("Times", fontStyle, fontSize);
        String s = new String(ID+"="+ height);
        
        TextLayout tl = new TextLayout(s, f, frc);
        TextLayout t2 = new TextLayout(Integer.toString(l_node.getIDVal()), f, frc);
        TextLayout t3 = new TextLayout(Integer.toString(r_node.getIDVal()), f,
        frc);
        
        DrawingUtility.drawBeam(l_node.x + Node.w/2, l_node.y+Node.h/2,
        r_node.x+Node.w/2, r_node.y+Node.h/2 ,g2);
        DrawingUtility.showID(l_node.x + Node.w/2, l_node.y+Node.h/2,
        r_node.x+Node.w/2, r_node.y+Node.h/2 ,g2, tl, t2, t3);
   }

    public void draw(Graphics g)
    {
        if(prevPainted){
            prevPainted = false;
            return;
        }
        prevPainted = true;

        adjustCenter();
        adjustNodes();

        if(l_node.isSelected && r_node.isSelected )g.setColor(Color.red);
        else g.setColor(Color.black);
        Graphics2D g2 = (Graphics2D) g;
        
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);

        g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                            RenderingHints.VALUE_RENDER_QUALITY);

	int dist = (int)Math.pow((Math.pow((r_node.x-l_node.x),2)+Math.pow((r_node.y-l_node.y),2)),0.5) ;
        int fontSize =(int)(dist/4) ;
        if(fontSize>12) fontSize = 12;
        if(fontSize <6) fontSize = 8;
        int fontStyle ;
        if(fontSize<9) fontStyle = Font.BOLD ;
        else fontStyle = Font.PLAIN;
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = new Font("Times", fontStyle, fontSize);
        String s = new String(ID+"="+ length);
        TextLayout tl = new TextLayout(s, f, frc);
        TextLayout t2 = new TextLayout(Integer.toString(l_node.getIDVal()), f, frc);
		TextLayout t3 = new TextLayout(Integer.toString(r_node.getIDVal()), f,
		frc);
        DrawingUtility.drawBeam(l_node.x + Node.w/2, l_node.y+Node.h/2,
        r_node.x+Node.w/2, r_node.y+Node.h/2 ,g2);
        //DrawingUtility.showID(l_node.x + Node.w/2, l_node.y+Node.h/2,
        //r_node.x+Node.w/2, r_node.y+Node.h/2 ,g2, tl);
        DrawingUtility.showID(l_node.x + Node.w/2, l_node.y+Node.h/2,
        r_node.x+Node.w/2, r_node.y+Node.h/2 ,g2, tl, t2, t3);
          
    }
    
    public void basicDraw(Graphics g)
    {
        if(prevPainted){
            prevPainted = false;
            return;
        }
        prevPainted = true;

        adjustCenter();
        adjustNodes();

        if(l_node.isSelected && r_node.isSelected )g.setColor(Color.red);
        else g.setColor(Color.black);
        Graphics2D g2 = (Graphics2D) g;
        
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                            RenderingHints.VALUE_ANTIALIAS_ON);

        g2.setRenderingHint(RenderingHints.KEY_RENDERING,
                            RenderingHints.VALUE_RENDER_QUALITY);

	int dist = (int)Math.pow((Math.pow((r_node.x-l_node.x),2)+Math.pow((r_node.y-l_node.y),2)),0.5) ;
        int fontSize =(int)(dist/4) ;
        if(fontSize>12) fontSize = 12;
        if(fontSize <6) fontSize = 8;
        int fontStyle ;
        if(fontSize<9) fontStyle = Font.BOLD ;
        else fontStyle = Font.PLAIN;
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = new Font("Times", fontStyle, fontSize);
        String s = new String(ID+"="+ width);
        TextLayout tl = new TextLayout(s, f, frc);
        DrawingUtility.drawBeam(l_node.x + Node.w/2, l_node.y+Node.h/2,
        r_node.x+Node.w/2, r_node.y+Node.h/2 ,g2);
    }
    

}
